#ifndef CV_CONNECTOR_H
#define CV_CONNECTOR_H

#include <vector>

#include "Canvas.h"
#include "Label.h"
#include "WayPoint.h"
#include "Point.h"
//#include "geometry.h"
//#include "ConnectorEnd.h"
//#include "Label.h"
//#include "WayPoint.h"
//#include "Rect.h"

namespace cv {

	class Arrow;
	class ConnectorEnd;
	class Label;
	class WayPoint;
	

	// - relative must deal with segments length
	// 
	//##ModelId=4D60563300EC
	class Connector : public Canvas 
	{
		public:
		
		//##ModelId=4D63313301B5
		typedef std::vector<Label*> LabelsVector;
		
		public:
    //##ModelId=4D7303770271
    enum ConnectPolicy {Oblique, Orthogonal};

    //##ModelId=4D729E240203
    typedef Upp::Array<WayPoint*> WayPointVector;

  public:
    //##ModelId=4D6056330243
		ConnectorEnd * head;
		
		//##ModelId=4D6056330248
		ConnectorEnd * tail;
		
		//##ModelId=4D605633025B
		Connector(Canvas* owner);
		//##ModelId=4D605633025D
		Connector(Canvas* owner, Canvas* tail);
		//##ModelId=4D6056330260
		Connector(Canvas* owner, Canvas* head, Canvas* tail);
		
		//##ModelId=4D66CDC4037A
		// affects bounds()
		Point& get_origin();
		//##ModelId=4D66CDC4038A
		// affects bounds()
		Point& get_extent();

    //##ModelId=4D72D24000DA
    Rect& bounds();
		
    //##ModelId=4D729FBE01A5
    WayPointVector waypoints;
    
    //##ModelId=4D72C1600196
    WayPoint& addPoint(Point p);

		//##ModelId=4D6056330264
		void paint();
		
		// - QUOTE =  [0..1]
		// - answer a point that is QUOTE/percent 
		// of the connector length starting from the TAIL
		// 
		//##ModelId=4D6457000167
		Point relative(double quote);
		
		// answer the relative quote from TAIL
		// of the connector's point nearest to P
		//##ModelId=4D6462CB0128
		double relative(Point& p);
		
    //##ModelId=4D7159C5007D
		Point relative(Position pos);
		
		//##ModelId=4D691F2400AB
		void moveRelative(Point p);
		
		
		//##ModelId=4D609571032C
		Point center();
		
		// connector's length
		//##ModelId=4D645A94000F
		double length();
		
		//##ModelId=4D6056330265
		void connect(Canvas* c);
		
		//##ModelId=4D72BAC3007D
		void connect(Canvas* tailSide, Canvas* headSide);

    //##ModelId=4D72C07F01F4
		bool contains(Point pt);
		
		//##ModelId=4D6056330269
		bool isConnector();
		//##ModelId=4D613EBB0251
		bool isConnectedTo(Canvas* c);
		
		//##ModelId=4D64434B00CB
		void showArrows(bool state=true);
		
		//##ModelId=4D633205005E
		LabelsVector labels;
		
		//##ModelId=4D6EE69B02FD
		bool dashed;

		//##ModelId=4D6328840196
		Label* newLabel(std::string text, Position position);
    //##ModelId=4D72F40C0109
    void compactWayPoints();
    //##ModelId=4D7413BB0232
    bool hasPoints();
    //##ModelId=4D74400E02AF
    virtual void beMinimal();


    //##ModelId=4D744011008C
    virtual void beNormal();
    // MTDrag send this to say it has finished sending moveRelative msgs
    //##ModelId=4D74432D0399
    virtual void stopMoving();
    //##ModelId=4D74C74D030D
    void remove();
    // protocol: converting
    //##ModelId=4D75815E029F
    Canvas* asCanvas();

    // do not move (since its ends should move when ends canvas move)
    //##ModelId=4D7772AF003E
    void move(float x, float y);
    // do not move (since its ends should move when ends canvas move)
    //##ModelId=4D7773870213
    void move(Point p);



  private:
    //##ModelId=4D72EC6A032C
    WayPoint* activePoint;

	};
} // namespace cv
#endif
