#include "Selection.h"
#include "macros.h"
#include "canvas.h"

#include "Handler.h"

namespace cv {
	
//##ModelId=4D605633035D
	void Selection::add(Canvas* c){
		if (!includes(c)){
			elts.push_back(c);
			c->player->setSelected(true);
			//c->diagram()->selectTree(c);
		}
	}
	
//##ModelId=4D73CE4200BB
	void Selection::toggle(Canvas* c){
		if (includes(c))
			remove(c);
		else
			add(c);
	}
	
	//##ModelId=4D745D3801D4
	Canvas* Selection::at(int index){
		if (elts.size() >= index+1)
			return elts[index];
		else
			return NULL;
	}
	
//##ModelId=4D605633035F
	void Selection::clear(){
		each(Canvas,elts) 
			(*i)->player->setSelected(false);
		elts.clear();
	}

//##ModelId=4D6D591A0203
	void Selection::selectOnly(Canvas* obj, bool bePersistent){
		persistent=bePersistent;
		clear();
		add(obj);
	}
	
//##ModelId=4D6056330360
	bool Selection::includes(Canvas* c){
		each(Canvas,elts) if (c==*i) return true;
		return false;
	}
	
//##ModelId=4D6056330362
	void Selection::moveRelative(Point p){
		each(Canvas,elts){
			//(*i)->beMinimal();
			(*i)->moveRelative(p);
		}
	}

	//##ModelId=4D7441490271
	void Selection::stopMoving() {
		each(Canvas,elts)
			(*i)->stopMoving();
	}
	
	//##ModelId=4D6056330364
	void Selection::remove(Canvas* c){
		each(Canvas,elts)
			if (*i == c){
				elts.erase(i);
				return;
			}
	}
	
//##ModelId=4D6056330366
	int Selection::size(){
		return elts.size();
	}


//##ModelId=4D605633035C
	Rect Selection::bounds(){
		Rect r(999999,999999,0,0);
		each(Canvas,elts)
			r += (*i)->bounds();
		return r;
	}


}

