#include "DiagramEditor.h"

#include "Handler.h"
#include "Command.h"

using namespace Upp;

namespace cv {
	
	//##ModelId=4D71C832037A
	void DiagramEditor::set_diagram(Diagram* diagram){
		subject=diagram;
		canvas.dispatcher = &subject->listener;
		browser.set_subject(diagram->player);
		
		fixedHalos.subject = diagram->player;
		toolbar.Set(callback(&fixedHalos, &Halos::set_toolbar_contents));
	}

	//##ModelId=4D6CC59603B9
	DiagramEditor::DiagramEditor(Diagram* c) 
	{
		vSplit << browser << docedit;
		vSplit.Vert();
		hSplit << vSplit << canvas;
		hSplit.SetPos(0);
		
		AddFrame(toolbar);
		Add(hSplit.VSizePos(0,12));
		
		fixedHalos.tb = &toolbar;
		fixedHalos.diagramEditor = this;
		
		Add(float_toolbar);
		floatingHalos.tb = &float_toolbar;
		floatingHalos.diagramEditor = this;
		// its subject is set by HighLight::drawHalos
		
		set_diagram(c);
		
		Sizeable();
		Title("a DiagramEditor").MaximizeBox().MinimizeBox().Sizeable();
		SetRect(40, 40, 900, 700);
		
		WhenClose = THISBACK(Break);
		//show_rulers.WhenAction = THISBACK(showRulers);
		
		//canvas.WhenMouseMove = callback(new update_rulers(&hRuler,&vRuler), &update_rulers::action);
		OpenMain();
	}
	
	//##ModelId=4D72B92A00BB
	void DiagramEditor::showRulers(){
		//bool value = show_rulers.GetData();
		//hRuler.Show(value);
		//vRuler.Show(value);
	}

	
//##ModelId=4D6CC59603AB
#if 0
	LRESULT EditorDialog::WindowProc(UINT message, WPARAM wParam, LPARAM lParam){
		if (displayBuffer != ""){
			w->Title(displayBuffer);
			displayBuffer="";
		}
		return TopWindow::WindowProc(message,wParam,lParam);
	}
#endif	
	// 
  //##ModelId=4D6CC59603BC
	void DiagramEditor::State(int reason){ 
		switch(reason)
		{
			case DEACTIVATE:
			
			case OPEN:
			case CLOSE:
			case ENABLE:
			case SHOW:
			case LAYOUTPOS:
			case ACTIVATE:
			case FOCUS:
				break;
				
			case EDITABLE:
				//canvas.enabled=true;
				//canvas.Refresh();
				break;

			case POSITION:
			{
				canvas.enabled=false;
				StringStream s;
				s << GetSize().cx << "@" << GetSize().cy;
				//display(s.GetResult());
			}
		}
	}
} // namespace cv




