#ifndef GROUP_H_HEADER_INCLUDED_B29520B8
#define GROUP_H_HEADER_INCLUDED_B29520B8

#include <vector>

#include "canvas.h"
#include "Rect.h"
#include "geometry.h"
#include "text.h"
#include "Image.h"
#include "Ellipse.h"

namespace cv {

// TODO Does a group is a View too?
//##ModelId=4D6AA1900290
class Group : public Canvas
{
  public:
    //##ModelId=4D6C72360222
    bool bordered;

    //##ModelId=4D6AA3B80148
    Rect& bounds();
    //##ModelId=4D6AA4B4036B
    void add(Canvas* part, Position position = South);
    //##ModelId=4D6AA64401B5
    Group(Canvas* owner);
    //##ModelId=4D6AA68400AB
    void paint();
    
    //##ModelId=4D6AAC4F0399
    void remove(Canvas* part);
    
    // MTPick need this
    //##ModelId=4D6AADE3008C
    bool isShape();
    //##ModelId=4D6D4CB203B9
    Image* addImage(std::string img_name);
    //##ModelId=4D6C711D01A5
    void addSeparator();
    //##ModelId=4D6C7677032C
    Text* addText(std::string text);
    //##ModelId=4D6D43760000
    Ellipse* addEllipse();
    //##ModelId=4D74CE050109
    void remove();



    //##ModelId=4D6AA4290000
    Canvas::CanvasVector parts;

  private:
    //##ModelId=4D6AA5FE01F4
    int spacing;

};

} // namespace cv



#endif /* GROUP_H_HEADER_INCLUDED_B29520B8 */
