#ifndef _canvas_Rect_h_
#define _canvas_Rect_h_

#include "geometry.h"
#include "Point.h"
#include <Core/Core.h>
using Upp::Rectf;

namespace cv {

//##ModelId=4D65DD7D01F9
	class Rect : public Rectf {
		
	public:

    //##ModelId=4D65DD7D02B6
    Rect() : Rectf() {}
    //##ModelId=4D65DD7D02B7
    Rect(Rect& r) : Rectf(r){}
    //##ModelId=4D65DD7D02B9
    Rect(Point p1, Point p2) : Rectf(p1,p2){}
    //##ModelId=4D65DD7D02BC
    Rect(double l,double t,double r,double b) : Rectf(l,t,r,b){}
    		
    //##ModelId=4D65DD7D02C1
    Point& at(Position c){
      static Point pt;
      switch(c){
        case North: 
        	pt.x=(left+right)/2; 
        	pt.y=bottom;
        	break;
        case NorthEast:
        	pt.x=right;
        	pt.y=bottom;
        	break;
        case East:
        	pt.x=right;
        	pt.y=(top+bottom)/2; 
        	break;
        case SouthEast:
        	pt=Point(right,bottom);
        	break;
        case South:
        	pt.x=(left+right)/2; 
        	pt.y=bottom;
        	break;
        case SouthWest:
        	pt.x=left;
        	pt.y=bottom;
        	break;
        case West:
        	pt.x=left;
        	pt.y=(top+bottom)/2; 
        	break;
        case NorthWest:
        	pt=Point(left,top);
        	break;
      }
      return pt;
    }

    //##ModelId=4D65DD7D02C3
		double width(){ return right - left; }
    //##ModelId=4D65DD7D02C4
		double height(){ return bottom - top; }

    //##ModelId=4D65DD7D02C5
    bool contains(Point p);
    
    //##ModelId=4D65DD7D02C7
    Rect& operator +=(Point p);
    //##ModelId=4D65DD7D02C9
    Rect operator +=(const Rect& );
    //##ModelId=4D72D4B10222
    Rect& operator +=(double );
    //##ModelId=4D65DD7D02CB
    Point center();
    //##ModelId=4D65DD7D02CC
    bool intersectionFrom(Point reference, Point& intersection);
	};

}
#endif
