#ifndef _canvas_Editor_h_
#define _canvas_Editor_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#include "CanvasCtrl.h"
#include "Ruler.h"

#define LAYOUTFILE <canvas/lay2.lay>
#include <CtrlCore/lay.h>

#include "images.h"
#include "Point.h"
#include "Diagram.h"

//gm
#include "VBrowser.h"
#include "Handler.h"
#include "Halos.h"

namespace cv {

	//##ModelId=4D6D01DE01B5
	typedef WithEditor<TopWindow> WithEditor;
	
	//##ModelId=4D6D2BEE0177
	typedef WithParts<TopWindow> WithParts;

	void display(String s);

	//##ModelId=4D6CC596035B
	struct PartsDialog : public WithParts {
    //##ModelId=4D6CC5970000
		PartsDialog() {
			CtrlLayout(*this, "-- parts --");
		}
	};

	//##ModelId=4D6CC596033E
	class DiagramEditor : public TopWindow //WithEditor
	{
  public:

    //##ModelId=4D7597240272
    VBrowser browser;

    //##ModelId=4D74DEBA007F
		Splitter hSplit;
    //##ModelId=4D7597240291
		Splitter vSplit;
    //##ModelId=4D75972402A0
		DocEdit docedit;
    //##ModelId=4D74DEBA009D
		CanvasCtrl canvas;
    //##ModelId=4D74DEBA00AC
		ToolBar toolbar;
    //##ModelId=4D74DEBA00BC
		ToolBar float_toolbar;
    //##ModelId=4D74DEBA00CC
		Button btn;
		
    //##ModelId=4D77614D0001
		Halos fixedHalos;
    //##ModelId=4D776A78007E
		Halos floatingHalos;

    //##ModelId=4D70E7E400FA
    struct update_rulers
    {
      //##ModelId=4D70E7E40222
			update_rulers(Ruler* _r1, Ruler* _r2)
				: r1(_r1)
				, r2(_r2)
				{/**/}

      //##ModelId=4D70E7E40225
			void action(Point p){
				r1->set(p);
				r2->set(p);
			}

      //##ModelId=4D70E8BE0168
      cv::Ruler *r1;

	    //##ModelId=4D70E8BE0178
	    cv::Ruler *r2;
    };

    //##ModelId=4D71C832037A
		void set_diagram(Diagram* diagram);

    //##ModelId=4D6CC59603B9
		DiagramEditor(Diagram* c);

    //##ModelId=4D72B92A00BB
		void showRulers();
		

    
    //##ModelId=4D71A71B037A
    Diagram *subject;
		
  private:
    //##ModelId=4D71C3AF01B5
    typedef DiagramEditor CLASSNAME;
		
    //##ModelId=4D6CC59603AA
		void Break(){ exit(0); }


    //##ModelId=4D6CC59603BC
    void State(int reason);
	};
	
} // namespace cv

#endif
