#include <iostream>
using std::cout;

#include "assert.h"

#include "Connector.h"
#include "Diagram.h"
#include "UppCanvas.h"
#include "Rect.h"
#include "Handler.h"

#include "macros.h"
#include "canvas.h"

namespace cv {

	//##ModelId=4D6314460001
	Canvas::Canvas(Canvas* c)
		:owner(c)
		, origin(0,0)
		, extent(0,0)
		, selected(false)
		, visible(true)
		, group(NULL)
		, player(gm::Handler::getNullPlayer())
		{
			/**/
		}

	//##ModelId=4D631446000F
Canvas::Canvas(Canvas* c, float x1, float y1, float x2, float y2)
		: owner(c)
		, origin(x1,y1)
		, extent(x2,y2)
		, selected(false)
		, visible(true)
		, group(NULL)
		, player(gm::Handler::getNullPlayer())
		{
			/**/
		}

	//##ModelId=4D6314460035
	bool Canvas::isConnectedTo(Canvas* c){
		return false;
	}

	//##ModelId=4D6314460031
	bool Canvas::isConnector(){
		return false;
	}
	
	//##ModelId=4D6314460033
	bool Canvas::isShape(){
		return false;
	}

	//##ModelId=4D6314460030
	UppCanvas* Canvas::root(){
		return dynamic_cast<UppCanvas*>(view());
	}

//##ModelId=4D775C8B00CB
  void Canvas::addIncoming(Connector* cn){
    each(Connector,incoming)
    	if ((*i) == cn) return;
    incoming.push_back(cn);
  }
//##ModelId=4D775C8B0148
  void Canvas::addOutcoming(Connector* cn){
    each(Connector,outcoming)
    	if ((*i) == cn) return;
    outcoming.push_back(cn);
  }

	//##ModelId=4D73CAD10271
  void Canvas::removeOutcoming(Connector* cn) {
    each(Connector,outcoming)
    	if ((*i)==cn){
    		outcoming.erase(i);
    		return;
    	}
  }
	//##ModelId=4D73CAD1032C
  void Canvas::removeIncoming(Connector* cn){
    each(Connector,incoming)
    	if ((*i)==cn){
    		incoming.erase(i);
    		return;
    	}
  }

	//##ModelId=4D6C7BD00167
	Canvas* Canvas::view(){
		Canvas* iter;
		assert(owner || isView());
		for(iter=this; !iter->isView(); iter=iter->owner)
			assert(iter->owner != iter);
		return iter;
	}

	//##ModelId=4D631446002C
	Point Canvas::center(){
		return bounds().center();
	}

	//##ModelId=4D6314460024
	bool Canvas::contains(Point p){
		return bounds().contains(p);
	}

	//##ModelId=4D6314460027
	Rect& Canvas::bounds(){
		static Rect r;
		const Point& o = get_origin();
		const Point& e = get_extent();
		r.left = (o.x<e.x) ? o.x : e.x;
		r.top = (o.y<e.y) ? o.y : e.y;
		r.right = (e.x>o.x) ? e.x : o.x;
		r.bottom = (e.y>o.y) ? e.y : o.y;
		return r;
	}

	//##ModelId=4D6AA7D3030D
	void Canvas::move(Point p){
		set_origin(p);
	}

	//##ModelId=4D6C67CC0119
	void Canvas::move(float x, float y){
		set_origin(Point(x,y));
	}

	//##ModelId=4D6314460029
	void Canvas::moveRelative(Point p){
		if (flag){
			origin += p;
			extent += p;
			flag=false;
		}
	}

	//##ModelId=4D6314460038
	Point const& Canvas::get_origin() {
	    return origin;
	}
	
	
	//##ModelId=4D631446003A
	void Canvas::set_origin(Point left){
	    origin = left;
	}
	
	//##ModelId=4D631446003D
	Point const& Canvas::get_extent() {
	    return extent;
	}
	
	
	//##ModelId=4D631446003F
	void Canvas::set_extent(Point left){
	    extent = left;
	}
//##ModelId=4D6D50A801E4
	void Canvas::set_extent(float right,float bottom){ 
		set_extent(Point(right,bottom)); 
	}
	
	//##ModelId=4D6573DA0167
	int Canvas::get_radius() const{
	    return 0;
	}
	
	//##ModelId=4D6573DE035B
	void Canvas::set_radius(int left){
	    throw "error: Canvas cant set radius";
	}
	

	//##ModelId=4D623EB301F4
	TextStyle::TextStyle()
		: bold(false)
		, underline(false)
	{
	}

	//##ModelId=4D6C566600DA
	void Canvas::setFlag(bool value){
		flag = value;
	}
	
	//##ModelId=4D6C567902DE
	bool Canvas::getFlag(){
		return flag;
	}

	//##ModelId=4D6C6E3C0109
	bool Canvas::isElastic(){ return false; }

	//##ModelId=4D6C7A06009C
	void Canvas::add(Canvas* elt){/**/}

	//##ModelId=4D74A40C00CB
	void Canvas::openInHand(Canvas* c) {/**/}

	//##ModelId=4D714F9302BF
	// todo I work only for connectors
	double Canvas::distance(Point p) {
		Line l;
		l.start = get_origin();
		l.end = get_extent();
		return l.distance(p);
	}

	//##ModelId=4D72EEA5036B
	bool Canvas::isDragging() {
	}

	//##ModelId=4D73BE0B0399
	Diagram* Canvas::diagram() {
		return dynamic_cast<Diagram*>(view());
	}

	//##ModelId=4D743F85001F
	void Canvas::beMinimal() {
		each(Connector,incoming) (*i)->beMinimal();
		each(Connector,outcoming) (*i)->beMinimal();
	}
	
	//##ModelId=4D743F8F0290
	void Canvas::beNormal() {
		each(Connector,incoming) (*i)->beNormal();
		each(Connector,outcoming) (*i)->beNormal();
	}

	//##ModelId=4D7442AD0157
	void Canvas::stopMoving() {
		beNormal();
	}

	//##ModelId=4D74C5E1007D
	void Canvas::remove() {
		while(incoming.size()) incoming[0]->remove();
		while(outcoming.size()) outcoming[0]->remove();
		diagram()->remove(this);
	}

	//##ModelId=4D75767F035B
	Connector* Canvas::asConnector() {
		assert(isConnector());
		return dynamic_cast<Connector*>(this);
	}

	//##ModelId=4D7581450290
	Canvas* Canvas::asCanvas() {return this;}

}


