#include "Rect.h"

namespace cv {

//##ModelId=4D65DD7D02C5
	bool Rect::contains(Point p){
		return Rectf::Contains(p);
	}
	
	//##ModelId=4D65DD7D02C9
	Rect Rect::operator+=(const Rect& r){
		Rectf::Union(r);
		return *this;
	}
	
	//##ModelId=4D72D4B10222	
	Rect& Rect::operator+=(double value){
		Rectf::Inflate(value);
		return *this;
	}
	
	//##ModelId=4D65DD7D02C7
	Rect& Rect::operator +=(Point p){
		if (p.x > right) right = p.x;
		if (p.x < left) left=p.x;
		if (p.y > bottom) bottom = p.y;
		if (p.y < top) top = p.y;
		return *this;
	}
	
	//##ModelId=4D65DD7D02CB
	Point Rect::center(){
	 //Pointf p=Rectf::CenterPoint();
	 //return Point(p.x,p.y);
	 return Point(Rectf::CenterPoint());
	}

	//##ModelId=4D65DD7D02CC
	bool Rect::intersectionFrom(Point reference, Point& intersection){
		Line line;
		line.start.x = reference.x;
		line.start.y = reference.y;
		Point c=center();
		line.end.x = c.x;
		line.end.y = c.y;
		
		Line seg1;
		seg1.start.x = left;
		seg1.start.y = top;
		seg1.end.x   = right;
		seg1.end.y   = top;
		if (seg1.intersects(line,intersection)) return true;

		seg1.start.x = right;
		seg1.start.y = top;
		seg1.end.x   = right;
		seg1.end.y   = bottom;
		if (seg1.intersects(line,intersection)) return true;

		seg1.start.x = left;
		seg1.start.y = bottom;
		seg1.end.x   = right;
		seg1.end.y   = bottom;
		if (seg1.intersects(line,intersection)) return true;

		seg1.start.x = left;
		seg1.start.y = top;
		seg1.end.x   = left;
		seg1.end.y   = bottom;
		if (seg1.intersects(line,intersection)) return true;

		return false;			
	}
	
}
