#include "UppCanvas.h"

#include "Images.h"
#include "Text.h"
#include "Vect.h"

namespace cv {

	//##ModelId=4D605633037F
	void UppCanvas::drawCircle(Point center,float radius,int lineWidth,Upp::Color lineColor){
		Upp::Rect r;
		float r2=radius/2;
		_draw->DrawEllipse(center.x-r2/2,center.y-r2/2,r2,r2,lineColor,lineWidth,lineColor);
	}

	//##ModelId=4D6056330384
	void UppCanvas::drawLine(Point start, Point end, int lineWidth, Upp::Color color){
		drawLine(start.x,start.y,end.x,end.y,lineWidth,color);
	}

	//##ModelId=4D6056330389
	void UppCanvas::drawLine(float x1,float y1,float x2,float y2,int lineWidth, Upp::Color color,float angle, float x,float y){
		if (angle==0){
			_draw->DrawLine(x1,y1,x2,y2,lineWidth,color);
		}else{
			Point origin(x,y);
			Point p1(x1,y1);
			Point p2(x2,y2);
			Vect v1(origin,p1);
			Vect v2(origin,p2);
			//float angle_rad = 2*3.14 * angle / 3600;
			float angle_rad = angle;
			v1+=angle_rad;
			v2+=angle_rad;
			float xx1=v1.x(),yy1=v1.y(),xx2=v2.x(),yy2=v2.y();
			
			drawLine(xx1,yy1,xx2,yy2,lineWidth,color);
		}
	}
	
//##ModelId=4D6312F0035B
	void UppCanvas::drawEmptyPoly(Rect& r, int lineWidth, Upp::Color color){
		Upp::Vector<Upp::Point> p;
		int x1=r.left, y1=r.top, x2=r.right, y2=r.bottom;
		p << Upp::Point(x1,y1)
		  << Upp::Point(x2,y1)
		  << Upp::Point(x2,y2)
		  << Upp::Point(x1,y2)
		  << Upp::Point(x1,y1);
		_draw->DrawPolyline(p,lineWidth,color);
	}
	
	//##ModelId=4D6056330393
	void UppCanvas::drawPoly(Rect r, int lineWidth, Upp::Color borderColor, Upp::Color fillColor){
		Upp::Vector<Upp::Point> p;
		int x1=r.left, y1=r.top, x2=r.right, y2=r.bottom;
		p << Upp::Point(x1,y1)
		  << Upp::Point(x2,y1)
		  << Upp::Point(x2,y2)
		  << Upp::Point(x1,y2)
		  << Upp::Point(x1,y1);
		_draw->DrawPolygon(p,fillColor,lineWidth,Upp::Black,/*(uint64)*/0x00000000); //, color, lineWidth, Upp::Black, (uint64)0xaa55aa55aa55aa55, NULL);
	}

	//##ModelId=4D6056330397
	void UppCanvas::drawImage(float x, float y, Upp::Image img, float alpha){
		
		_draw->DrawImage(x,y,Upp::Rotate(img,alpha));
	}

	//##ModelId=4D65522300BB
	void UppCanvas::drawRoundRectangle(Rect r, float radius, int lineWidth, Upp::Color borderColor){
		float x1=r.left, y1=r.top;
		float w=r.width(), h=r.height();
		_draw->RoundedRectangle(x1,y1,w,h,radius).Stroke(lineWidth, borderColor);
		
	}

	//##ModelId=4D6228180213
	void UppCanvas::drawText(Text* text)
	{
		Upp::Font font = Upp::StdFont();
		if (text->style.bold) font.Bold();
		if (text->style.underline) font.Underline();
		_draw->DrawText(text->get_origin().x, text->get_origin().y, text->get_contents(),font);
	}

	//##ModelId=4D622CC50280
	Point UppCanvas::textSize(std::string text)
	{
		Point p;
		Upp::Size s = Upp::GetTextSize(text.c_str(),Upp::StdFont(),-1);
		p.x=s.cx;
		p.y=s.cy;
		return p;
	}

	//##ModelId=4D62440D0251
	void UppCanvas::drawEllipse(float x,float y,float cx,float cy,Upp::Color color, int lineWidth)
	{
		_draw->DrawEllipse(x,y,cx,cy,Upp::White,lineWidth,color);
	}
	
	//##ModelId=4D653F700222
	void UppCanvas::setCursor(std::string name){
		Upp::Ctrl::OverrideCursor(getImage(name));
	}

}
