#include "CanvasCtrl.h"
#include "Diagram.h"

#include <Painter/Painter.h>
using namespace Upp;

namespace cv {

	// ctor
	//##ModelId=4D6056330212
	CanvasCtrl::CanvasCtrl() 
		: Upp::Ctrl()
		, enabled(true)
		{/**/}
	
	//##ModelId=4D6056330213
	void CanvasCtrl::Paint(Upp::Draw & ws) {
		Upp::Size size=GetSize();
#if 1
		ImageBuffer ib(size);
		BufferPainter sw(ib, MODE_SUBPIXEL); /*MODE_ANTIALIASED	MODE_NOAA*/
			
		//ws.DrawRect(0,0,size.cx,size.cy,Upp::White);
		sw.Clear(White());
		
		// what does 2000 means ?
		PaintingPainter h(2000, 2000);

		if (enabled)
			dispatcher->doPaint(&h);

		sw.Paint(h);
		ws.DrawImage(0, 0, ib);

#else
		//PaintingPainter h(2000, 2000);
		
		//if (!view)
		//	view=new CanvasView(&ws);
		
		Upp::Ctrl::Paint(ws);
		
		
		//h.Clear(Upp::White());
		ws.DrawRect(0,0,size.cx,size.cy,Upp::White);
		
		if (enabled)
			dispatcher->doPaint(&ws);
		
#endif		
		enabled=true; // todo: enabled ge cleared by the container of CanvasView (State)
		}
	
	//##ModelId=4D605633020F
	void CanvasCtrl::dispatch(Event* evt, Upp::dword keyflags){
		evt->key_modifiers = 0;
		if ((keyflags & Upp::K_SHIFT)>0) evt->key_modifiers += K_SHIFT;
		if ((keyflags & Upp::K_CTRL)>0) evt->key_modifiers += K_CONTROL;
		if ((keyflags & Upp::K_ALT)>0) evt->key_modifiers += K_ALT;
		dispatcher->dispatch(evt);
		RefreshLayoutDeep();
	}
	
	//##ModelId=4D6056330215
	void CanvasCtrl::LeftDown(Upp::Point p, Upp::dword keyflags)  { 
		dispatch(new Event(LEFT_DOWN,p.x,p.y),keyflags);
	}

	//##ModelId=4D6056330218
	void CanvasCtrl::LeftDrag(Upp::Point p, Upp::dword keyflags)  { 
		dispatch(new Event(LEFT_DRAG,p.x,p.y),keyflags);
	}

	//##ModelId=4D605633021E
	void CanvasCtrl::LeftUp(Upp::Point p, Upp::dword keyflags)    { 
		dispatch(new Event(LEFT_UP,p.x,p.y),keyflags);
	}

	//##ModelId=4D605633021B
	void CanvasCtrl::MouseMove(Upp::Point p, Upp::dword keyflags) { 
		WhenMouseMove.Execute(Point(p.x,p.y));
		dispatch(new Event(MOUSE_MOVE,p.x,p.y),keyflags);
	}
	
	//##ModelId=4D6056330221
	bool CanvasCtrl::Key(Upp::dword key, int count){
		return true;
	}
	
}
