#include "ClassDiagram.h"

#include "assert.h"

#include "Command.h"
#include "Canvas.h"
#include "ConnectorEnd.h"
#include "Ellipse.h"
#include "Group.h"
#include "Image.h"
#include "Images.h"
#include "Text.h"

#include "Arrow.h"
#include "ScreenController.h"

#include "MActor.h"
#include "MClass.h"
#include "MIsa.h"
#include "MPackage.h"
#include "MUsecase.h"

#include <Core/Core.h>
using Upp::callback1;

namespace gm {

#define CMD(_img,_descr,_t) cmd = new Command(getImage(_img),_descr,_t); 	\
														cmd->cmd_type = Command::C_create;						\
														Handler::commands.push_back(cmd);
#define CMD2(_img,_descr,_t) cmd = new Command(getImage(_img),_descr,T_nil); 	\
														cmd->cmd_type = _t;																\
														Handler::commands.push_back(cmd);

	//##ModelId=4D6CBC960177
	ClassDiagram::ClassDiagram(Handler::ModelType t) 
		: Handler(t)
		, editor(NULL)
		{
			Command* cmd;
			if (Handler::commands.size() == 0){
				CMD("img_class","A class is a container for functions, variables and bugs.",T_Class);
				CMD("usecase","A piece of the system someon can act with or against.",T_Usecase);
				CMD("img_actor","A role/user or process that acts with the system.",T_Actor);
				//CMD("img_note","Some notes about something.",T_Note);
				CMD("img_label","A label that can be attached to a connector.",T_Label);
				CMD("img_isa","Inheritance of one derived class from its base class.",T_ISA);
				CMD("img_dep","A dependency between a dependant and its dependency.",T_DEP);
				CMD("img_has","A relation between an owner and its owned object.",T_HAS);
				CMD("img_has2","A relation between an owner and its aggregate object.",T_AGG);
	
				CMD2("img_clean","Clear selected elements."	, Command::C_clear);
				CMD2("img_all","Select all."								, Command::C_all);
				
				//CMD2("img_exit","Quit."								, Command::C_all);
			}
		}

	//##ModelId=4D6CBC5A01D4
	ModelEditor* ClassDiagram::edit() {
		switch(get_type()){
			case T_ClassDiagram:
				{
					cdiagram=new cv::Diagram();
					cdiagram->player = this;
					editor=ScreenController::diagram(cdiagram);
#if 0
					{
						Handler* m1; // model
						Handler* m2;
						Handler* m3;
						Handler* m4;
						Handler* m5;
						
						Handler* mc1; // model connector
						Handler* mc2;
						Handler* mc3;
						Handler* mc4;
						
						cv::Canvas* c1; // canvas
						cv::Canvas* c2;
						cv::Canvas* c3;
						cv::Canvas* c4;
						cv::Canvas* c5;
						
						cv::Canvas* cn1; // connector
						cv::Canvas* cn2;
						cv::Canvas* cn3;
						cv::Canvas* cn4;
												
						create(T_Class,"NewClass", m1, c1);
						create(T_Usecase,"usecase", m2, c2);
						create(T_Class,"Bar", m2, c3);
						create(T_Actor,"foo", m4, c4);
						create(T_Class,"Zap", m5, c5);
						

						create(T_ISA, "xxx", mc1, cn1);
						((cv::Connector*)cn1)->connect(c1,c3);
						create(T_HAS, "xxx", mc2, cn2);
						((cv::Connector*)cn2)->connect(c2,c3);
						create(T_DEP, "", mc3, cn3);
						((cv::Connector*)cn3)->connect(c4,c3);
						create(T_HAS, "", mc4, cn4);
						((cv::Connector*)cn4)->connect(c5,c3);
						
						cdiagram->add(c1);
						cdiagram->add(c2);
						cdiagram->add(c3);
						cdiagram->add(c4);

						cdiagram->add(cn1);
						cdiagram->add(cn2);
						cdiagram->add(cn3);
						cdiagram->add(cn4);
						
						c1->move(cv::Point(100,100));
						c2->move(cv::Point(400,100));
						c3->move(cv::Point(250,250));
						c4->move(cv::Point(100,400));
						c5->move(cv::Point(400,400));
						
						editor->Refresh();
						
					}
#endif					
					
					//editor->Run();
					Ctrl::EventLoop();
					
					return NULL; // this is a strange case: the editor exists in the diagram ...
				}
				break;
		}
	}
	
	//##ModelId=4D6D2F1D0196
	void ClassDiagram::create(Handler::ModelType type, std::string _name, Handler*& newModel, cv::Canvas*& newCanvas){
    cv::Canvas* c;
    cv::Group* g;
    cv::Connector* cn;

    switch(type){
			case T_Actor:
    	case T_Usecase:
    	case T_Class:
    		{
					g=new cv::Group(cdiagram);
					cdiagram->add((cv::Canvas*)g);
					switch(type)
					{
						case T_Actor:
							newModel = new MActor();
							g->bordered=false;
							g->addImage("actor");
							g->addText(_name);
							break;
			    	case T_Usecase:
			    	{
			    		newModel = new MUsecase();
			  			g->bordered=false;
							cv::Ellipse* obj = g->addEllipse();
							obj->set_extent(cv::Point(50,20));
							g->addText(_name);
			    	}
							break;
			    	case T_Class:
			    		newModel = new MClass();
			    		g->addText(_name);
							g->addSeparator();
							g->addSeparator();
			    		break;
					}
					c = (cv::Canvas*) g;
    		}
				break;
			case T_ISA:
				c = new cv::Connector(cdiagram);
				{
					newModel = new MIsa();
					cn = (cv::Connector*) c;
					cn->head->arrow->type = cv::ClosedEmpty;
					cn->tail->arrow->type = cv::None;
					cdiagram->add(cn->asCanvas());
				}
      	break;
			case T_HAS:
				c = new cv::Connector(cdiagram);
				{
					newModel = new ClassDiagram(type);
					cn = (cv::Connector*) c;
					cn->head->arrow->type = cv::OpenArrow;
					cn->tail->arrow->type = cv::DiamondEmpty;
					cn->newLabel("HEAD",cv::NearHead);
					cn->newLabel("CENTER",cv::NearCenter);
					cn->newLabel("TAIL",cv::NearTail);
					cdiagram->add(cn->asCanvas());
				}
      	break;
			case T_DEP:
				c = new cv::Connector(cdiagram);
				{
					newModel = new ClassDiagram(type);
					cn = (cv::Connector*) c;
					cn->head->arrow->type = cv::OpenArrow;
					cn->tail->arrow->type = cv::None;
					cn->dashed = true;
					cdiagram->add(cn->asCanvas());
				}
				break;
    }
    
    newModel->name = _name;
    add(newModel);
    c->player = newModel;
    
    newCanvas = c;
	}

	//##ModelId=4D72B48C033C
	Handler* ClassDiagram::createAndInsert(Handler::ModelType type, std::string _name) {
		Handler* model;
		cv::Canvas* canvas;
    if (type == T_Label){
      model = new Handler(type);
      model->name = _name;
			cdiagram->selectConnectorRelativePoint(model);
			return model;
    }
		create(type, _name, model, canvas);
    cdiagram->openInHand(canvas);
    return model;
	}

	//##ModelId=4D6F6F1A003E
	bool ClassDiagram::canConnectFrom(Handler* tail) {

		if (!tail)
			return Handler::canConnectFrom(tail);

		switch(get_type()){
			case Handler::T_ISA:
				return tail->get_type() == Handler::T_Class;
			default: 
				return Handler::canConnectFrom(tail);
		}
	}

	//##ModelId=4D6F6F1D0128
	bool ClassDiagram::canConnectTo(Handler* head, Handler* connector){
		if (!head) 
			return Handler::canConnectTo(NULL,connector);
			
		// MClass replace ISA's player to ITSELF
		// so we can't test type, since now is a T_CLASS
		// -> we loose the information about the kind of the relation
			
		switch(connector->get_type()){
			case Handler::T_ISA: 
				return head->get_type() == Handler::T_Class;
			default: 
				break;
		}
		return Handler::canConnectTo(head,connector);
	}

	//##ModelId=4D701AC602BF
	void ClassDiagram::setSelected(bool state) 
	{
		ScreenController::dia_editor->Title(String(name));
		ScreenController::dia_editor->docedit.Set(String(name));
		Handler::setSelected(state);
	}

	//##ModelId=4D759C6302BF
	void ClassDiagram::perform(Command* cmd) {
		switch(cmd->cmd_type){
			
			case Command::C_clear:
				cdiagram->clear(); 
				ScreenController::dia_editor->Refresh();
				break;

			case Command::C_all:
				cdiagram->selectAll(); 
				ScreenController::dia_editor->Refresh();
				break;
				
			case Command::C_create:
				switch(cmd->mdl_type){
					case T_ISA:
					case T_DEP:
					case T_HAS:
						{
							cv::Canvas* cn;
							Handler* newModel;
							create(cmd->mdl_type, "", newModel, cn);
							cdiagram->startWiring(cn->asConnector());
						}
						break;
					default:
						createAndInsert(cmd->mdl_type,"xxx");
						break;
				}
		}
	}
	
}


