#ifndef CLASSDIAGRAM_H_HEADER_INCLUDED_B293786B
#define CLASSDIAGRAM_H_HEADER_INCLUDED_B293786B

#include "Handler.h"
#include "Diagram.h"
#include "ModelEditor.h"
#include "DiagramEditor.h"
#include "Command.h"

namespace cv {
	class Connector;
}

namespace gm {

	// --- ui ---
	// a screenmanager is shared among all sub-models?
	//##ModelId=4D6CB1B802CE
	class ClassDiagram : public Handler
	{
	public:
	
		//##ModelId=4D6EF81F01C5
		typedef ClassDiagram CLASSNAME;
		
	public:

		//##ModelId=4D6CBC960177
		ClassDiagram(Handler::ModelType t);
		
		//##ModelId=4D6CBC5A01D4
		ModelEditor* edit();

		//##ModelId=4D6F6F1A003E
		bool canConnectFrom(Handler* tail);

		//##ModelId=4D6F6F1D0128
		bool canConnectTo(Handler* head, Handler* connector);

		//##ModelId=4D701AC602BF
		void setSelected(bool state);

		//##ModelId=4D72B48C033C
		Handler* createAndInsert(Handler::ModelType type, std::string _name);

		// protocol: command
		//##ModelId=4D759C6302BF
		void perform(Command* cmd);
		
		//##ModelId=4D75A40E031C
		virtual bool isDiagram() {return true;}
		
		//##ModelId=4D71C99C002F
		Upp::TopWindow* editor;
		
	protected:
	
		//##ModelId=4D6D2F1D0196
		virtual void create(Handler::ModelType type, std::string _name, Handler*& newModel, cv::Canvas*& newCanvas);
};
} // namespace gm
#endif /* CLASSDIAGRAM_H_HEADER_INCLUDED_B293786B */
