#include "Ellipse.h"
#include "UppCanvas.h"

namespace cv{

	//##ModelId=4D62461700FA
	Ellipse::Ellipse(Canvas* owner, float x, float y, float cx, float cy)
		: Rectangle(owner,x,y,cx,cy)
	{
	}

	//##ModelId=4D6246B0033C
	void Ellipse::paint()
	{
		int lineWidth = (selected ? 2 : 1);
		root()->drawEllipse(origin.x,origin.y,extent.x,extent.y,Upp::Black,lineWidth);
	}

	//##ModelId=4D6248AC0222
	Point const& Ellipse::get_extent()
	{
		static Point _extent;
		Point& p = (Point&) get_origin();
		_extent.x = p.x + extent.x * 1;
		_extent.y = p.y + extent.y * 1;
		return _extent;
	}

	//##ModelId=4D624B480242
	void Ellipse::moveRelative(Point pt){
		if (getFlag()){
			origin += pt;
			setFlag(false);
		}
	}

}


