#include "Group.h"

#include "macros.h"
#include "Separator.h"
#include "UppCanvas.h"
#include "Diagram.h"

namespace cv {

	//##ModelId=4D6AA64401B5
	Group::Group(Canvas* owner)
		: Canvas(owner)
		, spacing(3)
	{
	}
	
	//##ModelId=4D6AA68400AB
	void Group::paint()
	{
		Point p = get_origin();
		p.y += spacing;
		
		each(Canvas,parts){
			(*i)->move(p);
			(*i)->paint();
			p.y = (*i)->get_extent().y + spacing;
		}
		
		if (bordered)
			root()->drawEmptyPoly(bounds(),1);
	}
	
	//##ModelId=4D6AA3B80148
	Rect& Group::bounds(){
		static Rect r;
		r.Set(999999,999999,0,0);
		each(Canvas,parts) 
			if (!(*i)->isElastic())
				r+=(*i)->bounds();
		r += spacing*2;
		return r;
	}
	
	//##ModelId=4D6AA4B4036B
	void Group::add(Canvas* part, Position position){
		/*if (part->group)
			part->group->remove(part);*/
		part->group = this;
		parts.push_back(part);
	}

	//##ModelId=4D6AAC4F0399
	void Group::remove(Canvas* part){
		each(Canvas,parts)
			if ((*i) == part){
				parts.erase(i);
				break;
			}
	}

	//##ModelId=4D6AADE3008C
	bool Group::isShape(){
		return true;
	}
	
	//##ModelId=4D6D4CB203B9
	Image* Group::addImage(std::string img_name){
		Image* obj=new Image(owner,Point(0,0),img_name);
		((Diagram*)owner->view())->add(obj);
		add(obj);
		return obj;
	}
	
	//##ModelId=4D6C711D01A5
	void Group::addSeparator(){
		add(new Separator(this));
	}

	//##ModelId=4D6C7677032C
	Text* Group::addText(std::string text){
		Text* t=new Text(owner);
		((Diagram*)owner->view())->add(t);
		add(t);
		t->set_contents(text);
		return t;
	}
	
	//##ModelId=4D6D43760000
	Ellipse* Group::addEllipse(){
		Ellipse* obj=new Ellipse(owner,0,0,40,30);
		((Diagram*)owner->view())->add(obj);
		add(obj);
		return obj;
	}

	//##ModelId=4D74CE050109
	void Group::remove() {
		each(Canvas,parts)
			(*i)->remove();
		parts.clear();
		Canvas::remove();
	}
	
}




