#ifndef HANDLER_H_HEADER_INCLUDED_B29359DC
#define HANDLER_H_HEADER_INCLUDED_B29359DC

#include "Tool.h"
#include "ModelEditor.h"

namespace gm {

	class Command;
	class Proxy;
	
	// My predicates tell about what a model can do
	//##ModelId=4D6CB1E8032C
	class Handler
	{
	public:
    //##ModelId=4D6D66120138
    typedef vector<Command*> CommandVector;
    
    //##ModelId=4D6CB95201D4
    enum ModelType { T_nil, T_Actor, T_Class, T_Note, T_Label, T_ClassDiagram, T_ISA, T_AGG, T_HAS, T_REALIZE, T_DEP, T_Function, T_Variable, T_Usecase, T_Package };

    //##ModelId=4D75CB6902CE
    typedef Upp::Array<Handler*> HandlerVector;

    //##ModelId=4D75EFA4009D
		cv::Diagram* cdiagram;


    //##ModelId=4D702AB10128
    String name;
    

    //##ModelId=4D75CDAD01B6
    HandlerVector elts;
    // my ID in Browser
    //##ModelId=4D77A05A0203
    int id;
    //##ModelId=4D75A3C5037D
    Handler* owner;


    
    //##ModelId=4D75A3F700AB
    virtual bool isDiagram(){return false;}
    
    //##ModelId=4D75A48D030D
    virtual bool canConnectFrom(Handler* tail);

    //##ModelId=4D6CB37901D4
    virtual bool canConnectTo(Handler* head, Handler* connector);
    
    //##ModelId=4D6CB4E30157
    virtual bool canOwn(Handler* m);
    
    //##ModelId=4D70189D01E4
    virtual void setSelected(bool state);

    //##ModelId=4D7014CF0222
    virtual ModelEditor* edit();
    
    //##ModelId=4D72845A000F
    static Handler* getNullPlayer();
    
    //##ModelId=4D7472A70251
    Handler(ModelType t);
    
    // protocol: command
    //##ModelId=4D758F5503D8
    virtual bool canPerform(Command* cmd);
    // protocol: command
    //##ModelId=4D7595BC02EE
    virtual void perform(Command* cmd);

		//protocol: containement
		//##ModelId=4D75CFB803D8
    Handler* at(int index);
    //##ModelId=4D75CBFB03B9
    //protocol: containement
    void add(Handler* h);
    //##ModelId=4D75CDD1001F
    //protocol: containement
    void remove(Handler* h);
    //protocol: containement
    //##ModelId=4D75CF4303B9
    int size();
    //##ModelId=4D7715300213
    Handler* newProxy();


    //##ModelId=4D7716F70213
    virtual Handler::ModelType get_type();
    //##ModelId=4D7719A10157
    virtual CommandVector& get_commands();
    //##ModelId=4D7759980242
    void set_type(Handler::ModelType t);
    //##ModelId=4D77A5590213
    void remove();



  protected:
  
    //##ModelId=4D6D66120158
    static CommandVector commands;

  private:
    // A bulk object that does nothing.
    // avoid NULL check in Canvas
    //##ModelId=4D7283B8033C
    static Handler* nullPlayer;

    //##ModelId=4D746F9B008C
    ModelType type;

	};

} // namespace gm



#endif /* HANDLER_H_HEADER_INCLUDED_B29359DC */
