#include "MTConnect.h"

#include "ConnectorEnd.h"
#include "Handler.h"
#include "Diagram.h"

#include "macros.h"

namespace cv {

	//##ModelId=4D60563302F0
	MTConnect::MTConnect(Diagram* c)
		:MouseTool(c) 
		,connector(NULL)
		,state(idle)
		{/**/}	
		
	//##ModelId=4D64356A000F
	void MTConnect::startWiring(Connector* c){
		connector=c;
		connector->showArrows(false);
		if (connector->tail->isFree())
			enterState(wiringTail);
		else if (connector->head->isFree())
			enterState(wiringHead);
		else
			enterState(idle);
	}

	//##ModelId=4D613690005D
	void MTConnect::finished(){
		connector->showArrows();
		connector=NULL;
		enterState(idle);
		Tool::finished();
	}
	
	//##ModelId=4D64360A008C
	void MTConnect::abort(){
		connector->remove();
		connector=NULL;
		enterState(idle);
	}
	
	// -> event must be already notified
	//##ModelId=4D64356A002E
	void MTConnect::enterState(connectState newState){
		state = newState;
		switch(newState){
			case wiringTail:
				connector->beMinimal();
				connector->visible=false;
				connector->tail->beFree(event_point);
				diagram->setCursor("img_wiring_tail");
				break;
			case wiringHead:
				connector->beMinimal();
				connector->visible=true;
				connector->head->beFree(event_point);
				diagram->setCursor( "img_wiring_head");
				break;
			case idle:
				// CONNECTOR has yet gone
				diagram->setCursor("img_cursor");
				break;
		}
		if (state != idle)
			if (diagram->selection.size()>0)
				diagram->selection.clear();
	}

	//##ModelId=4D64356A001F
	bool MTConnect::validTarget(){
		if (!event_target) {
			if (state==wiringTail)
				diagram->setCursor("img_wiring_tail");
			else
				diagram->setCursor("img_wiring_head");
			return false;
		}
		if (event_target->isConnectedTo(connector)) {
			if (state==wiringTail)
				diagram->setCursor("img_wiring_tail_veto");
			else
				diagram->setCursor("img_wiring_head_veto");
			return false;
		}
		
		bool r;
		//if (event_target->player && connector->player) // TODO why labels have player==NULL?
		if (state==wiringTail)
			r = connector->player->canConnectFrom(event_target->player);
		else
			r = connector->tail->canvas->player->canConnectTo(event_target->player,connector->player);
		
		if (r)
			if (state==wiringTail) diagram->setCursor("img_wiring_tail_ok");
			else diagram->setCursor("img_wiring_head_ok");
		else
			if (state==wiringTail) diagram->setCursor("img_wiring_tail_veto");
			else diagram->setCursor("img_wiring_head_veto");
				
		return r;
	}

	//##ModelId=4D76EC5500EA
	void MTConnect::linkToTheNull() {
		bool r;
		if (state==wiringTail)
			r = connector->player->canConnectFrom(NULL);
		else
			r = connector->tail->canvas->player->canConnectTo(NULL,connector->player);
		
		if (r)
			finished();
		else
			abort();
	}

	//##ModelId=4D60563302F4
	bool MTConnect::notify(Event* evt)
	{
		event_target = NULL;
		each(Canvas,evt->subjects){
			if ((*i) != connector){
				event_target = *i;
				break;
			}
		}
		event_point=evt->pt;
		
		if (state == leavingTail){
			if (!event_target)
				enterState(wiringHead);
			return true;
		}
		
		if (event_target)
			while(event_target->group)
				event_target=event_target->group;
		
		if (state==idle) return false;
		if (!evt->isMouseEvent()) return false;
		if (!connector) return false;
		bool r=false;
		switch(evt->tag)
		{
			case MOUSE_MOVE:
				
				switch(state)
				{
					case wiringTail:
						if (validTarget()){
							if (event_target->isShape()){
								connector->tail->beCentered(event_target);
								diagram->selection.selectOnly(event_target,false);
							}else{
								connector->tail->beRelative(event_target,event_point);
							}
						}else{
							connector->tail->beFree(evt->pt);
						}
						return true;

					case wiringHead:
						if (validTarget()){
							if (event_target->isShape()){
								connector->head->beCentered(event_target);
								diagram->selection.selectOnly(event_target,false);
							}else{
								connector->head->beRelative(event_target,event_point);
							}
							connector->beNormal();
						}else{
							connector->beMinimal();
							connector->head->beFree(evt->pt);
						}
						return true;
				}
				break;
				
			case LEFT_DOWN:
				switch(state){
					case wiringTail:
						if (validTarget()){
							if (event_target->isShape()){
								connector->tail->beCentered(event_target);
								diagram->selection.selectOnly(event_target,false);
							}else{
								connector->tail->beRelative(event_target,event_point);
							}
							connector->beNormal();
							enterState(leavingTail);
							return true;
						} else
							linkToTheNull();
						break;
						
					case wiringHead:
						if (validTarget())
							finished();
						else
							linkToTheNull();
						break;
				}
				return true;
		}
	}

	
}



