#ifndef _canvas_MTPick_h_
#define _canvas_MTPick_h_

#include "MouseTool.h"
#include "canvas.h"
#include "event.h"
#include "connector.h"
#include "geometry.h"

namespace cv{

	// - picking a part of a group means picking the group
//##ModelId=4D6056330149
	class MTPick : public MouseTool {
	  public:

		//##ModelId=4D6056330304
		MTPick(Diagram* c) 
			:MouseTool(c) 
			, pickedConnectorPoint(false)
			, readyToWiring(false)
		{/**/};
		
    //##ModelId=4D72B10C02EE
		void paint();
	
		//##ModelId=4D6056330306
		bool notify(Event* evt);
    //##ModelId=4D74BD3402DE
    bool isReadyToWiring();

		
		
  protected:
    //##ModelId=4D72B10C02DE
		bool pickedConnectorPoint;
		
	private:
		
    //##ModelId=4D73017C007D
		Connector* firstConnector(Event* evt);
		
		//##ModelId=4D6206680271
		bool pickShape(Event* evt, bool persistent);
		
		// pick the background (or the Diagram if you prefer)
		//##ModelId=4D771DC301A5
    bool pickNull(Event* evt);
		
		//##ModelId=4D62070F01C5
		bool pickConnector(Event* evt);
    //##ModelId=4D72FDDE0000
		bool isNearConnectorHead(Event* evt);
    //##ModelId=4D72FDDE000F
		bool isNearConnectorTail(Event* evt);
    //##ModelId=4D74BD710138
    bool readyToWiring;

		
		
	};

}
#endif
