#include "MTPickRelative.h"

#include "Diagram.h"
#include "Label.h"
#include "geometry.h"
#include "MTPick.h"

//gm
#include "Handler.h"


namespace cv {

	//##ModelId=4D72AA4B0167
	MTPickRelative::MTPickRelative(Diagram* c)
		:MouseTool(c)
	{/**/}

	//##ModelId=4D72A7320157
	bool MTPickRelative::notify(Event* evt) {
    if (!evt->isMouseEvent() || !isActive())
      return false;

    switch(evt->tag)
    {
      case LEFT_DOWN:
    		finished();
    		return false;

      case MOUSE_MOVE:
    		nearestConnector = diagram->nearestConnector(evt->pt);
    		if (nearestConnector){
    			diagram->selection.selectOnly(nearestConnector,true);
    			Point pH = nearestConnector->relative(NearHead);
    			Point pC = nearestConnector->relative(NearCenter);
    			Point pT = nearestConnector->relative(NearTail);
    			double dH = evt->pt.distance(pH);
    			double dC = evt->pt.distance(pC);
    			double dT = evt->pt.distance(pT);
    			if (dH < dC) {
    				pt=pH;
    				nearestRelative = NearHead;
    			} else {
    				if (dT < dC){
    					pt=pT;
    					nearestRelative = NearTail;
    				} else {
    					pt=pC;
    					nearestRelative = NearCenter;
    				}
    			}
    			return true;
    		} else {
    			// no connectors in the view
    			finished();
    			return false;
    		}
		}
	}

	//##ModelId=4D72A7F401A5
	void MTPickRelative::paint() {
		if (isActive())
			diagram->root()->drawCircle(pt,12,2,Upp::Red());
	}

	//##ModelId=4D72A82702EE
	void MTPickRelative::finished() {
		diagram->picker->setEnabled(true);
		setActive(false);
		if (nearestConnector){
			Canvas* c = nearestConnector->newLabel(model->name,nearestRelative);
		}
		diagram->selection.clear();
		diagram->setCursor("img_cursor");
	}

	//##ModelId=4D7144FE00FA
	void MTPickRelative::startPickingRelative(gm::Handler* m) {
		// todo: m is not used
		diagram->picker->setEnabled(false);
		setActive(true);
		model=m;
	}
	
}




