#include "Vect.h"

#include "geometry.h" // just to set 2nd point of a Vect (move to a function, common to both Line & Vect)

namespace cv {

	//##ModelId=4D60563303A4
  Vect::Vect() 
  	:radius(0)
  	,alpha(0)
		,at_origin(false)
	{/**/}

	//##ModelId=4D60563303A5
  Vect::Vect(Point zero, double angle, double _radius)
		: origin(zero)
		, alpha(angle)
		, radius(_radius)
		, at_origin(false)
	{/**/}

  //##ModelId=4D6458DD02C1
	Vect::Vect(Point zero, Point pt)
		: origin(zero)
	{
		at_origin = (zero==pt);
		if (!at_origin){
			radius=origin.distance(pt);
			alpha=asin((pt.y-origin.y) / radius);
		}
	}

	//##ModelId=4D6A4C8701F4
	double Vect::get_alpha() const {
		return alpha;
	}
	
	//##ModelId=4D6A4C870213
	void Vect::set_alpha(double left) {
	    alpha = left;
	}

//##ModelId=4D6A88A10203
	void Vect::rotate(double angle, bool anti){
		alpha = alpha + (anti ? -angle : angle);
		/*if (alpha < -1 * M_PI/2)
			alpha += 2*M_PI;
		else if (alpha >= 3/2*M_PI)
			alpha -= 2*M_PI;*/
	}

  //##ModelId=4D670FA00272
	void Vect::set_origin(Point p){
		if (p != origin){
			origin=p;
		}
	}

  //##ModelId=4D60563303A8
	void Vect::set(double x,double y){
		set(Point(x,y));
	}

  //##ModelId=4D67F6BE0290
	void Vect::set(Point pt){
		Line l(origin,pt);
		radius = l.length();
		alpha = l.alpha();
	}

  //##ModelId=4D68E2A8008C
	void Vect::set(Point _origin, Point _extent){
		set_origin(_origin);
		set(_extent);
	}
	
  //##ModelId=4D69034B03AA
	Vect& Vect::operator=(Vect& rhs){
		origin = rhs.origin;
		radius = rhs.radius;
		alpha = rhs.get_alpha();
		return *this;
	}

	//##ModelId=4D60563303AB
	Vect& Vect::operator+=(double angle){ 
		alpha+=angle; 
		/////////////////////////////////////////////////// normalize
		return *this;
	}
	
	//##ModelId=4D60563303AD
	double Vect::x(){ 
		if (at_origin)
			return origin.x;
		else
			return origin.x + cos(alpha) * radius; 
	}
	
	//##ModelId=4D60563303AE
	double Vect::y(){ 
		if (at_origin)
			return origin.y;
		else
			return origin.y + sin(alpha) * radius; 
	}

	//##ModelId=4D645A27000F
	Point Vect::asAbsolutePoint(){
		Point p(x(),y());
		/*Upp::StringStream ss;
		ss << "[VECT] " << p.ToString();
		LOG(ss.GetResult());*/
		return p;
	}
}