#ifndef CV_SELECTION_H
#define CV_SELECTION_H

#include <vector>
using namespace std;
#include "geometry.h"
#include "Rect.h"

namespace cv {

	class Canvas;
	
	//##ModelId=4D605633015D
	class Selection {
	  private:
	    //##ModelId=4D605633035B
	    vector<Canvas*> elts;
	
	  public:
		//##ModelId=4D605633035C
		Rect bounds();
		
		//##ModelId=4D6D591A0203
		void selectOnly(Canvas* obj, bool persistent=false);
		
		//##ModelId=4D605633035D
		void add(Canvas* );
		
    //##ModelId=4D745D3801D4
		Canvas* at(int index);
		
		//##ModelId=4D73CE4200BB
		void toggle(Canvas* c);
		
		//##ModelId=4D605633035F
		void clear();
		
		//##ModelId=4D6056330360
		bool includes(Canvas* );
		
		//##ModelId=4D6056330362
		void moveRelative(Point );
		
		//##ModelId=4D6056330364
		void remove(Canvas* );
		
		//##ModelId=4D6056330366
		int size();
		// MTDrag send this to say it has finished sending moveRelative msgs
		//##ModelId=4D7441490271
		void stopMoving();
		
		// Selections of one canvas set on the flight by the free hand
		// are not persistent. Only when you click a canvas the selection
		// results to be persistent.
		//##ModelId=4D6D1EB5035B
		bool persistent;

	
	};

} // namespace cv
#endif
