#include "Label.h"

#include "ConnectorEnd.h"
#include "Diagram.h"

#include "assert.h"

namespace cv {

	//##ModelId=4D632A3203B9
	Label::Label(Connector* owner, std::string text)
		: Text(owner->asCanvas()->owner,0,0)
		{
			((Diagram*) owner->asCanvas()->owner)->add(this);
			end = new ConnectorEnd(owner,this);
			set_contents(text);
		}

	//##ModelId=4D632D41038A
	void Label::paint()
	{
		set_origin(end->point());
		Text::paint();
		if (selected)
		{
			Point fromConnector = attachment();
			Point fromLabel = center();
			Rect r=bounds();
			r += 4;
			r.intersectionFrom(fromConnector,/*out*/fromLabel);
			root()->drawLine(fromLabel,fromConnector,1);
		}
	}
	
	//##ModelId=4D691F240167
	Point Label::attachment(){
		return end->connector->relative(end->attachment.position);
	}
	
	//##ModelId=4D6711530000
	void Label::moveRelative(Point delta){
		end->moveRelative(delta);
	}

}


