#include "MTDrag.h"
#include "Diagram.h"

namespace cv{
	
	//##ModelId=4D654EAE03C8
	void MTDrag::finished(){
		if (state == dragging)
			diagram->selection.stopMoving();
		state = idle;
		if (clearSelectionWhenFinished){
			diagram->selection.clear();
			clearSelectionWhenFinished = false;
		}
		Tool::finished();
	}
	
	//##ModelId=4D71176C007D
	void MTDrag::startDragging(Point startPoint){
		pt=startPoint;
		state = dragging;
		setActive(true);
		moved=false;
		diagram->highLighter->hideHalos();
	}

	//##ModelId=4D74A71901D4
	void MTDrag::startHandling(Canvas* c) {
		handledCanvas = c;
		handledCanvas->beMinimal();
		handledCanvas->move(diagram->tracker->pt);
		state = handling;
	}
	
	//##ModelId=4D71191802EE
	void MTDrag::dragTo(Point endPoint){
		moved=true;
		Point delta;
		if (endPoint != pt){
	  	delta=endPoint - pt;
	  	diagram->selection.moveRelative(delta);
	  	pt=endPoint;
		}
	}
	
	//##ModelId=4D6056330301
  bool MTDrag::notify(Event* evt){ 

    if (!evt->isMouseEvent())
      return false;
    
		switch(state){
			case dragging:
				switch(evt->tag){
      		case LEFT_UP:
      			if (moved)
							if (diagram->selection.size() == 1)
								// clear selection at the end of a dragging session 
								// if only one canvas was selected
								clearSelectionWhenFinished = true;
						finished();
						return false;
					case MOUSE_MOVE:
						dragTo(evt->pt);
				  	return true;
				}

			case handling:
				switch(evt->tag){
					case LEFT_DOWN:
						handledCanvas->beNormal();
						handledCanvas=NULL;
						state = idle;
						return false;
					case MOUSE_MOVE:
						handledCanvas->move(evt->pt);
						return true;
					default:
						return false;
				}
				
			case idle:
				switch(evt->tag){
					case LEFT_DOWN:
						if (diagram->selection.bounds().contains(evt->pt)){
							startDragging(evt->pt);
							return true;
						}
				}
				return false;
		}
  }
  
}

