#include "HighLight.h"
#include "Diagram.h"

#include "Handler.h"
#include "Command.h"

#include "ScreenController.h"

#include "macros.h"
#include "Options.h"

namespace cv{
	
  //##ModelId=4D60563302CA
	HighLight::HighLight(Diagram* c) 
    :Tool(c)
  {
  }

	//##ModelId=4D7460DA0222
	void HighLight::drawHalos(Point where) {

		int halosWidth = 250;
		int halosHeight = 20;
		bool halosTransparent = !false;

		DiagramEditor* wnd = gm::ScreenController::dia_editor;
		ToolBar& tb = wnd->float_toolbar;

		// set halo's subject = the Diagram or first from diagram->selection
		switch(diagram->selection.size()){
			case 0:
				wnd->floatingHalos.subject = diagram->player;
				break;
			case 1:
				wnd->floatingHalos.subject = diagram->selection.at(0)->player;
				break;
			default:
				wnd->floatingHalos.subject = diagram->player;
				break;
		}
		
		tb.Set(callback(&wnd->floatingHalos, &Halos::set_toolbar_contents));
		tb.Show();
		tb.Transparent(halosTransparent);
		double x;
		x = where.x + wnd->canvas.GetRect().left - halosWidth/3;
		tb.SetRect( (x>=0) ? x : 0,where.y,halosWidth,halosHeight);
	}

	//##ModelId=4D7723A902CE
	void HighLight::hideHalos() {
		DiagramEditor* wnd = gm::ScreenController::dia_editor;
		ToolBar& tb = wnd->float_toolbar;
		tb.Show(false);
	}
	
	//##ModelId=4D60563302CC
  void HighLight::paint() {
    if (diagram->selection.size() >0){
      if (!diagram->isDragging()){
				Rect r;
				r=diagram->selection.bounds();
				r += 6;
				
				if (!diagram->isWiring()
		    		&& !diagram->isPicking()
		    		&& (diagram->selection.persistent || cv::Options::showHalosImmediately))
		    	{
						drawHalos(Point( r.left,r.top-20));
					} else {
						hideHalos();
					}
				
				int width = diagram->selection.persistent ? 3:2;
				
				int radius=6;
				Upp::Color color = Upp::Cyan();
				if (diagram->isReadyToWiring()){
	        color = Upp::Red();
	        width = 3;
	      }
	      diagram->drawRoundRectangle(r,radius,width,color);
			}
		}
	}
}


