#ifndef _canvas_Vect_h_
#define _canvas_Vect_h_

#include "Point.h"

namespace cv {

	//##ModelId=4D605633016B
	class Vect
	{
	  //##ModelId=4D605633039C
		bool at_origin;
	  //##ModelId=4D60563303A2
		double alpha;

		public:
	  //##ModelId=4D605633039E
		Point origin;
	  //##ModelId=4D60563303A3
		double radius;
		
		//##ModelId=4D60563303A4
	  Vect();
	
		//##ModelId=4D60563303A5
    Vect(Point zero, double angle, double _radius);

	  //##ModelId=4D6458DD02C1
		Vect(Point zero, Point pt);
		
    //##ModelId=4D6A88A10203
		void rotate(double angle, bool anti = false);
				
    //##ModelId=4D670FA00272
		void set_origin(Point p);
	
    //##ModelId=4D60563303A8
		void set(double x,double y);
		
    //##ModelId=4D67F6BE0290
		void set(Point pt);
		
    //##ModelId=4D68E2A8008C
		void set(Point _origin, Point _extent);
		
    //##ModelId=4D69034B03AA
		Vect& operator=(Vect& rhs);
		
    //##ModelId=4D60563303AB
		Vect& operator+=(double angle);
		
		//##ModelId=4D60563303AD
		double x();
		
		//##ModelId=4D60563303AE
		double y();
		
		//##ModelId=4D645A27000F
		Point asAbsolutePoint();

    //##ModelId=4D6A4C8701F4
    double get_alpha() const;

	
    //##ModelId=4D6A4C870213
    void set_alpha(double left);

};
}

#endif
