#ifndef CV_CANVAS_H
#define CV_CANVAS_H

#include "geometry.h"
#include <vector>
using namespace std;

#include <Core/Core.h>
#include "Point.h"
#include "Rect.h"

namespace gm{ 
	class Handler; 
}

namespace cv {
	
	class Diagram;
	class Rect;
	class Event;
	class Connector;
	class UppCanvas;

	//##ModelId=4D63144502FD
	class Canvas {
  public:
    //##ModelId=4D63144502FE
    typedef vector<Canvas*> CanvasVector;
    
    //##ModelId=4D73C31A009C
    typedef vector<Connector*> ConnectorVector;

	protected:
		//##ModelId=4D63144503C9
		Point origin;
		//##ModelId=4D63144503D9
		Point extent;

	public:
	
		//##ModelId=4D6D420000BC
		gm::Handler * player;

		//##ModelId=4D6314460000
		bool selected;

		//##ModelId=4D6439280280
		bool visible;

		//##ModelId=4D63144503BC
		Canvas * owner;

		//##ModelId=4D6AAC03001F
		Canvas* group;

    // a list of connectors having HEAD attached to this canvas
    //##ModelId=4D73C3F90177
    ConnectorVector incoming;
    // a list of connectors having TAIL attached to this canvas
    //##ModelId=4D73C4000000
    ConnectorVector outcoming;
    // remove link Canvas/Connector not the Connector itself
    //##ModelId=4D73CAD10271
    void removeOutcoming(Connector* cn);
    // remove link Canvas/Connector not the Connector itself
    //##ModelId=4D73CAD1032C
    void removeIncoming(Connector* cn);
    
    //##ModelId=4D775C8B00CB
    void addIncoming(Connector* cn);
    //##ModelId=4D775C8B0148
    void addOutcoming(Connector* cn);
    

		//##ModelId=4D6314460001
		Canvas(Canvas* );
		//##ModelId=4D631446000F
		Canvas(Canvas*,float,float,float,float);
				
		//##ModelId=4D631446001F
		inline virtual void notify(Event* ) {};
		
		//##ModelId=4D6314460022
		virtual void paint() = 0;
		
		//##ModelId=4D6314460027
		virtual Rect& bounds();

		//##ModelId=4D6AA7D3030D
		virtual void move(Point p);
		//##ModelId=4D6C67CC0119
		virtual void move(float x, float y);
		
		//##ModelId=4D6314460029
		virtual void moveRelative(Point );
		
		//##ModelId=4D631446002C
		virtual Point center();
		//##ModelId=4D631446002E
		inline virtual bool isView() {return false;};
		
		//##ModelId=4D6314460030
		UppCanvas* root();
		
		//##ModelId=4D6C7BD00167
		Canvas* view();
		
		//##ModelId=4D6314460031
		virtual bool isConnector();
		
		//##ModelId=4D6314460033
		virtual bool isShape();
		
		//##ModelId=4D6314460035
		virtual bool isConnectedTo(Canvas* c);

		//##ModelId=4D6314460038
		virtual Point const& get_origin();
		
		//##ModelId=4D631446003A
		virtual void set_origin(Point left);
		
		
		//##ModelId=4D631446003D
		virtual Point const& get_extent();
		
		//##ModelId=4D631446003F
		virtual void set_extent(Point left);
    //##ModelId=4D6D50A801E4
		virtual void set_extent(float right,float bottom);
		
		//##ModelId=4D6573DA0167
		virtual int get_radius() const;
		
		//##ModelId=4D6573DE035B
		virtual void set_radius(int left);
		//##ModelId=4D6C566600DA
		void setFlag(bool value);
		//##ModelId=4D6C567902DE
		bool getFlag();
		
		//##ModelId=4D6C6E3C0109
		// Sparator are not
		// (Group does not comput elastic canvas size)
		virtual bool isElastic();
		
		//##ModelId=4D6C7A06009C
		virtual void add(Canvas* elt);

	  // same as add, but attach the canvas to the mouse
	  //##ModelId=4D74A40C00CB
	  virtual void openInHand(Canvas* c);

    //##ModelId=4D714F9302BF
    virtual double distance(Point p);

    //##ModelId=4D72EEA5036B
    virtual bool isDragging();

		//##ModelId=4D6314460024
		virtual bool contains(Point );

    //##ModelId=4D73BE0B0399
    Diagram* diagram();

    //##ModelId=4D743F85001F
    virtual void beMinimal();

    //##ModelId=4D743F8F0290
    virtual void beNormal();
    
    // MTDrag send this to say it has finished sending moveRelative msgs
    //##ModelId=4D7442AD0157
    virtual void stopMoving();
    //##ModelId=4D74C5E1007D
    virtual void remove();

    // protocol: converting
    //##ModelId=4D75767F035B
    Connector* asConnector();
    // protocol: converting
    //##ModelId=4D7581450290
    Canvas* asCanvas();

  private:

    // moveRelative use this to avoid multiple dispatches
    //##ModelId=4D6C55E60109
    bool flag;
};

	//##ModelId=4D623ACE0138
	class TextStyle
	{
	  public:
    //##ModelId=4D623EB301F4
    TextStyle();

    //##ModelId=4D623AD70271
    bool bold;

    //##ModelId=4D623E4B038A
    bool underline;
	};

} // namespace cv

#endif
