#ifndef _canvas_Attachment_h_
#define _canvas_Attachment_h_

#include "geometry.h"
#include "Vect.h"

namespace cv {

	//##ModelId=4D60563300CE
	enum AttachmentPolicy {att_vector, att_relative, att_center, att_absolute, att_positional, att_free};

	//##ModelId=4D60563300CD
	class Attachment
	{
	  public:
		//##ModelId=4D60563301D3
		Attachment();

		/* Attachment::quote
		@when( policy == att_relative )
		-> a 0..1 percent of distance from reference point
		
		@when( policy == att_absolute )
		-> number of pixels from reference point */
		//##ModelId=4D60563301C3
		double quote;

		//##ModelId=4D60563301C5
		AttachmentPolicy policy;

		//##ModelId=4D60563301CA
		Position position;

		/* Attachment::freePoint
		@when (policy == att_free)
		indicates the freepoint where the ConnectorEnd points to */

		//##ModelId=4D60563301CF
		Point freePoint;
    //##ModelId=4D67025D002E
    Vect vector;

	};

}
#endif
