#include "Handler.h"
#include "Proxy.h"

#include "DiagramEditor.h"
#include "ScreenController.h"

#include "assert.h"

#define each(v) for(int i=0; i<elts.GetCount(); i++, v=elts[i])

namespace gm{

	//##ModelId=4D7472A70251
	Handler::Handler(ModelType t) 
		: type(t)
		, cdiagram(NULL)
		, owner(NULL)
	{/**/}

	//##ModelId=4D75A48D030D
	bool Handler::canConnectFrom(Handler* tail) {
		return tail!=NULL;
	}
	
	//##ModelId=4D6CB37901D4
	bool Handler::canConnectTo(Handler* head, Handler* connector) {
		return head!=NULL;
	}

	//##ModelId=4D6CB4E30157
	bool Handler::canOwn(Handler* m) {return true;}

	//##ModelId=4D70189D01E4
	void Handler::setSelected(bool state) {
		if (state)
			ScreenController::dia_editor->browser.select(this);
	}
	
	//##ModelId=4D7014CF0222
	ModelEditor* Handler::edit() {
		return NULL;
	}

	//##ModelId=4D7283B8033C
	Handler* Handler::nullPlayer = NULL;
	
	//##ModelId=4D72845A000F
	Handler* Handler::getNullPlayer() {
		if (!Handler::nullPlayer)
			Handler::nullPlayer = new Handler(T_nil);
		return Handler::nullPlayer;
	}
	
	//##ModelId=4D758F5503D8
	bool Handler::canPerform(Command* cmd) {return true;}

	//##ModelId=4D7595BC02EE
	void Handler::perform(Command* cmd) {
	}

	//protocol: containement
	//##ModelId=4D75CFB803D8
	Handler* Handler::at(int index){
		return elts[index];
	}
	
	//protocol: containement
	//##ModelId=4D75CF4303B9
	int Handler::size(){
		return elts.GetCount();
	}
	
	//##ModelId=4D75CBFB03B9
	//protocol: containement
	void Handler::add(Handler* h) {
		
		if (isDiagram()){
			if (h->owner)
				h->owner->remove(h);
			h->cdiagram = cdiagram;
		
			elts.Add(h);
			h->owner = this;
			
			cv::DiagramEditor* editor = ScreenController::dia_editor;
			editor->browser.add(h);
		}else
			owner->add(h);
	}

	//##ModelId=4D77A5590213
	void Handler::remove() { 
		if (owner)
			owner->remove(this);
	}
	
	//##ModelId=4D75CDD1001F
	//protocol: containement
	void Handler::remove(Handler* h) {
		Handler* elt; 
		bool found = false;
		for(int i = 0; !found && i<elts.GetCount(); i++){
			elt = elts[i];
			if (elt == h){
				elts.Remove(i);
				found = true;
			}
		}

		cv::DiagramEditor* editor = ScreenController::dia_editor;
		editor->browser.remove(h);
	}

	//##ModelId=4D7715300213
	Handler* Handler::newProxy() { return new Proxy(this); }
	
	//##ModelId=4D7716F70213
	Handler::ModelType Handler::get_type() {return type;}

	//##ModelId=4D7759980242
	void Handler::set_type(Handler::ModelType t) {type=t;}

	//##ModelId=4D6D66120158
	Handler::CommandVector Handler::commands;

	//##ModelId=4D7719A10157
	Handler::CommandVector& Handler::get_commands() {
		return Handler::commands;
	}
	
	
		
}




