#include "Image.h"
#include "images.h"
#include "UppCanvas.h"

namespace cv {
	//##ModelId=4D6D4A2C000F
	Image::Image(Canvas* owner, Point origin, std::string imgname)
		: Rectangle(owner,origin.x,origin.y,0,0)
		, img_name(imgname)
	{
		img=getImage(img_name);
	}
	
	//##ModelId=4D6D4A9101C5
	void Image::paint(){
		root()->drawImage(get_origin().x, get_origin().y,img,0);
	}

	//##ModelId=4D6D55F301C5
	Point& Image::get_extent() {
		static Point extent;
		Upp::Size sz = img.GetSize();
		extent.x = get_origin().x+sz.cx;
		extent.y = get_origin().y+sz.cy;
		return extent;
	}
	
}