#ifndef _canvas_Point_h_
#define _canvas_Point_h_

#include <Core/Core.h>
using Upp::Pointf;

#include "math.h"

namespace cv {

	//##ModelId=4D6056330158
	class Point : public Pointf {
  public:

    //##ModelId=4D65C3AB017C
		Point() :Pointf(){}
    //##ModelId=4D65C3AB019C
		Point(double x,double y) :Pointf(x,y){}
    //##ModelId=4D65DD7D0267
		Point(Upp::Pointf p) :Pointf(p){}
  
	  //##ModelId=4D6056330320
	  Point operator +(double );
	  //##ModelId=4D671153005D
	  Point operator +(Point );

    //##ModelId=4D6056330322
    Point operator -(double);
	  //##ModelId=4D6CC597000F
	  Point operator -(Point );
	  
	  //##ModelId=4D6056330324
	  bool operator==(Point p){ return ((x==p.x) && (y==p.y)); }
	  
	  //##ModelId=4D6056330326
	  double distance(Point other){
	    double xx=other.x-x;
	    double yy=other.y-y;
	    return sqrt(xx*xx+yy*yy);
	  }
	};

} // namespace: cv
#endif
