#include "geometry.h"

#include "math.h"

namespace cv {

	//##ModelId=4D60563302D9
	Line::Line()
		{/**/}
		
	//##ModelId=4D60563302DA
	Line::Line(Point _start,Point _end)
		:start(_start)
		,end(_end)
	{/**/}

	//##ModelId=4D608E2D034B
	double Line::alpha()
	{
		double r = sqrt(pow(start.x-end.x,2) + pow(start.y-end.y,2));
		double alpha = asin((start.y-end.y)/r);
#if 0
		if ((alpha<0) && (alpha >= -2*M_PI))
			return alpha + M_PI;

		if ((alpha>0) && (alpha <= 2*M_PI))
			return alpha - M_PI;

		return alpha;
#else
		double a2=0;
		int sign=1;
		if (start.y < end.y)
			if (start.x < end.x){
				sign = -1;
				a2 = 0;
			}else{
				sign = 1;
				a2 = M_PI;
			}
		else
			if (start.x < end.x){
				sign = -1;
				a2 = 0;
			}else{
				sign = 1;
				a2 = M_PI;
			}
		return sign * alpha + a2;
#endif
	}

	//##ModelId=4D60563302DD
	double Line::distance(Point& pt){
		double x1=start.x;
		double y1=start.y;
		double x2=end.x;
		double y2=end.y;
		double x3=pt.x;
		double y3=pt.y;
		
		double ds = pt.distance(start);
		double de = pt.distance(end);
		
		double area=(x1*y2 +x2*y3 +x3*y1 -x2*y1 -x3*y2 -x1*y3)/2;
		if (area<0) area=-1*area;
		double base = start.distance(end);
		double dl = 2*area/base;
		
		if ((dl<ds) && (dl<de)) return dl;
		if (ds < de) return ds;
		return de;
	}
	
	//##ModelId=4D646731031C
	double Line::length(){
		return start.distance(end);
	}
	
	//##ModelId=4D6463DA00AB
	double Line::relative(Point& p){
		
		double c1_length=distance(p);
		double ip_length=p.distance(start);
		double segment = sqrt(ip_length*ip_length - c1_length*c1_length);

		return segment / length();
	}
	
	//##ModelId=4D60563302DF
	bool Line::intersects(Line l, Point& p){
			double ua,ub;
			double x1=start.x, y1=start.y, x2=end.x, y2=end.y;
			double x3=l.start.x, y3=l.start.y, x4=l.end.x, y4=l.end.y;
			double denom = ((y4-y3)*(x2-x1)-(x4-x3)*(y2-y1));
			ua = ((x4-x3)*(y1-y3) - (y4-y3)*(x1-x3))/denom;
			ub = ((x2-x1)*(y1-y3)-(y2-y1)*(x1-x3))/denom;
			if ((ua<0) || (ua>1) || (ub<0) || (ub>1)) 
				return false;
			p.x= x1+ua*(x2-x1);
			p.y= y1+ua*(y2-y1);
			return true;
	}

}



