#include "MTPick.h"
#include "ConnectorEnd.h"
#include "Diagram.h"

#include "macros.h"

namespace cv{

	//##ModelId=4D6206680271
	bool MTPick::pickShape(Event* evt, bool persistent)
	{
		Canvas* pick_subject;
		pick_subject = evt->subjects.back();
		while(pick_subject->group)
			pick_subject=pick_subject->group;

		switch(evt->key_modifiers){
	    case 0:
	      diagram->selection.clear();

	    case K_CONTROL:
	    	diagram->selection.toggle(pick_subject);
	      break;

	    case K_ALT + K_CONTROL:
	    	diagram->selection.toggle(pick_subject);
	    	each(Connector,pick_subject->incoming)
	    		diagram->selection.toggle(*i);
	    	each(Connector,pick_subject->outcoming)
	    		diagram->selection.toggle(*i);
	    	break;
	    	
	  }
	  diagram->selection.persistent=persistent;
		return false;
	}

	//##ModelId=4D72B10C02EE
	void MTPick::paint(){
		if (pickedConnectorPoint);
			
			//diagram->root()->drawCircle(pt,12,1,Upp::Red());
		
	}

//##ModelId=4D73017C007D
	Connector* MTPick::firstConnector(Event* evt){
		if (evt->subjects.empty()) 
			return NULL;
		if (evt->subjects.back()->isConnector())
			return dynamic_cast<Connector*>(evt->subjects.back());
		else
			return NULL;
	}

	//##ModelId=4D72FDDE0000
	bool MTPick::isNearConnectorHead(Event* evt){
		Connector* cn=firstConnector(evt);
		if (!cn) return false;
		return (cn->head->point().distance(evt->pt) < 12);
	}

	//##ModelId=4D72FDDE000F
	bool MTPick::isNearConnectorTail(Event* evt){
		Connector* cn=firstConnector(evt);
		if (!cn) return false;
		return (cn->tail->point().distance(evt->pt) < 12);
	}

	//##ModelId=4D771DC301A5
	//
	// 1st click on the background clear selection and hide halos
	// a 2nd one get-up the halos
	//
	bool MTPick::pickNull(Event* evt)
	{
		if (diagram->selection.size()) {
			diagram->selection.clear();
			diagram->highLighter->hideHalos();
		}else{
			diagram->highLighter->drawHalos(evt->pt);
		}
		return false;
	}

	//##ModelId=4D62070F01C5
	bool MTPick::pickConnector(Event* evt)
	{
		Connector* cn=firstConnector(evt);
		//assert(cn!=NULL);
		
		//Point cp=cn->relative(cn->relative(evt->pt));
		Point cp = evt->pt;
		if (cp == pt){
			// second hit over the same point of a connector
			// (we assume the connector of previuos hit was this same connector)
			pickedConnectorPoint=true;
			cn->addPoint(pt);
			return false;
		} else {
			pt=cp;
			pickedConnectorPoint=false;
		}
		
		
		// pick-up the head/tail of a connector
		if (cn->head->point().distance(evt->pt) < 12){
			cn->head->beFree(evt->pt);
			diagram->startWiring(cn);
			return true;
		} else if (cn->tail->point().distance(evt->pt) < 12){
			cn->tail->beFree(evt->pt);
			diagram->startWiring(cn);
			return true;
		}
		return false;
	}
	


  //##ModelId=4D6056330306
	bool MTPick::notify(Event* evt){ 
    if (!evt->isMouseEvent())
      return false;

    switch(evt->tag)
      {
      case LEFT_DOWN:
				if (evt->subjects.empty() && !diagram->selection.bounds().contains(evt->pt))
				  return pickNull(evt);
				
			 	if (evt->subjects.empty())
			 		return false;
			 	
		    if (evt->subjects.back()->isConnector())
	        if (pickConnector(evt))
	        	return true;
				return pickShape(evt,true);

      case MOUSE_MOVE:
      	if (!enabled)
      		return false;
      	
      	if (!diagram->dragger->isActive()
      	    && !diagram->selection.persistent || (diagram->selection.size()==0))
      	{
      		if (isNearConnectorHead(evt)){
						diagram->setCursor("img_wiring_head");
						readyToWiring = true;
      		}else{
						if (isNearConnectorTail(evt)){
							diagram->setCursor("img_wiring_tail");
							readyToWiring = true;
						}else{
							diagram->setCursor("img_cursor");
							readyToWiring = false;
						}
      		}
						
					if (evt->subjects.empty() && !diagram->selection.bounds().contains(evt->pt)){
					  if (!diagram->selection.persistent) {
					  	diagram->selection.clear();
					  }
					}else
						if (!evt->subjects.empty())
							if (!diagram->selection.includes(evt->subjects.back()))
		      			return pickShape(evt,false);
      	}
		}
    return false;
  }

	//##ModelId=4D74BD3402DE
	bool MTPick::isReadyToWiring() {
		return readyToWiring;
	}
  
  
}


