#ifndef _canvas_ConnectorEnd_h_
#define _canvas_ConnectorEnd_h_

#include "geometry.h"
#include "Attachment.h"
#include "canvas.h"
#include "Point.h"

namespace cv {

	class Connector;
	class Canvas;
	class Arrow;

	//##ModelId=4D60563300FA
	class ConnectorEnd 
	{
    // todo check why this friendship
    friend class Connector;
    // REFACT remove this friend
    // selected label must show a line to the attachment point
    // when isVector the connector-relative is hidden
    // --
    friend class Label;

		private:
	  
    //##ModelId=4D6056330284
    ConnectorEnd* counterPart();
    
    //##ModelId=4D605633026B
    Point pt;
    
    //##ModelId=4D6056330270
    Attachment attachment;

	  public:
    //##ModelId=4D6056330285
    ConnectorEnd(Connector* connector, Canvas* c);
    //##ModelId=4D6056330288
    ConnectorEnd(Connector* connector);

    //##ModelId=4D6056330275
    Connector * connector;

    // the Canvas this ConnectorEnd connects to
    //##ModelId=4D631446006E
    Canvas * canvas;

    //##ModelId=4D73C92E0000
		bool isTail();
    //##ModelId=4D73C92E002E
		bool isHead();

    //##ModelId=4D605633028A
    Point point(bool exact=true);

    //##ModelId=4D605633027F
    Arrow * arrow;

    //##ModelId=4D6056330283
    float alpha;

    //##ModelId=4D605633028B
    bool connected();

    //##ModelId=4D6056330290
    void beFree();
    //##ModelId=4D605633028C
    void beFree(Point& pt);
    //##ModelId=4D6056330291
    bool isFree();
    //##ModelId=4D605633028E
    void beCentered(Canvas* c);

    // set relative to a point
    // todo? Canvas MUST be a Connector
    //##ModelId=4D646A6B0128
    void beRelative(Canvas* c, Point& p);
    
    // set relative to a position (head/center/tail)
    // todo? Canvas MUST be a Connector
    //##ModelId=4D690D730196
		void beRelative(Canvas* c, Position pos);
    
    //##ModelId=4D670871001F
    bool isVector(){ return attachment.policy==att_vector; }
    //##ModelId=4D6705CD006D
    void beVector(Vect v);
    //##ModelId=4D679850009C
    void moveRelative(Point delta);
    
    //##ModelId=4D66D40C037A
    Point& cached_point();


	  protected:
	};

}
#endif
