#ifndef _canvas_MTDrag_h_
#define _canvas_MTDrag_h_

#include "MouseTool.h"
#include "canvas.h"

namespace cv{

	//##ModelId=4D6056330148
	class MTDrag : public MouseTool {
	  public:
    //##ModelId=4D74A60D03D8
    enum DragState { dragging, handling, idle };

	    
    //##ModelId=4D631D32000F
		bool moved;
		
    //##ModelId=4D7445AE035B
		bool clearSelectionWhenFinished;
    //##ModelId=4D74A6590119
    DragState state;

	
    //##ModelId=4D60563302FF
    MTDrag(Diagram* c) 
    	:MouseTool(c) 
    	, state(idle)
    	, clearSelectionWhenFinished(false)
    	{};
	
    //##ModelId=4D6056330301
    bool notify(Event* evt);

	    
    //##ModelId=4D654EAE03C8
		void finished();
    //##ModelId=4D74A71901D4
    void startHandling(Canvas* c);
  private:
    //##ModelId=4D71176C007D
		void startDragging(Point startPoint);
    //##ModelId=4D71191802EE
		void dragTo(Point endPoint);
    //##ModelId=4D74A7D702DE
    Canvas* handledCanvas;


	};

}
#endif
