
#include "view.h"
#include "canvas/Player.h"

namespace cv {


	//##ModelId=4D81CF7D00B1
	bool Command::canSendTo(Handler* target) {
		return target->canPerform(this);
	}

	//##ModelId=4D81CF7D00B4
	void Command::send(Handler* aReceiver) {
		if (canSendTo(aReceiver)){
			aReceiver->perform(this);
		}
	}

	//##ModelId=4D7D097A0213
	int Handler::get_id() { return -1; }
	
	//##ModelId=4D7D09800138
	void Handler::set_id(int value) {/**/}

	//##ModelId=4D75A48D030D
	bool Handler::canConnectFrom(Handler* tail) {
		return tail!=NULL;
	}
	
	//##ModelId=4D6CB37901D4
	bool Handler::canConnectTo(Handler* head, Handler* connector) {
		return head!=NULL;
	}

	//##ModelId=4D6CB4E30157
	bool Handler::canOwn(Handler* m) {return true;}

	//##ModelId=4D70189D01E4
	void Handler::setSelected(bool state) {
		if (state)
			ScreenController::dia_editor->browser.select(this);
	}
	
	//##ModelId=4D7014CF0222
	void Handler::edit(){
		ScreenController::diagram(get_diagram());
		ScreenController::dia_editor->Execute(); //Open();
	}

	//##ModelId=4D758F5503D8
	bool Handler::canPerform(Command* cmd) {return true;}

	//##ModelId=4D7595BC02EE
	void Handler::perform(Command* cmd) {/**/}

	//##ModelId=4D7D052901F5
	cv::Handler::CommandVector Handler::commands;

	//##ModelId=4D7719A10157
	Handler::CommandVector& Handler::get_commands() {
		return Handler::commands;
	}

	//##ModelId=4D7283B8033C
	Handler* Handler::nullPlayer = NULL;
	
	//##ModelId=4D72845A000F
	Handler* Handler::getNullPlayer() {
		if (!Handler::nullPlayer)
			Handler::nullPlayer = new Handler();
		return Handler::nullPlayer;
	}



	//##ModelId=4D814C3401A5
	bool Player::canConnectTo(Handler* head, Handler* connector){
		return canConnectTo( dynamic_cast<Node*>(head), dynamic_cast<Arc*>(connector));
	}

	//##ModelId=4D83A7710177
	bool Player::canConnectTo(Node* head, Arc* connector){ return true; }
	
	bool Player::isConnectedTo(Player* object){
		assert(c);
		Canvas* other = get_context()->cdiagram->lookupSole(object);
		return c->isConnectedTo(other);
	}
	
	//##ModelId=4D81720A00EA
	void Player::build() {/**/}


  //##ModelId=4D81C18A01D4
	Node* Arc::get_tail(){
		assert(c);
		return (Node*) c->asConnector()->tail->canvas->get_player();
	}
  //##ModelId=4D81C18A01E5
	void Arc::set_tail(Node* obj){
		assert(c);
		if (c->asConnector()->tail->canvas)
			return c->asConnector()->tail->canvas->set_player(obj);
	}
	
  //##ModelId=4D81C18A0213
	Node* Arc::get_head(){
		assert(c);
		return (Node*) c->asConnector()->head->canvas->get_player();
	}
  //##ModelId=4D81C18A0223
	void Arc::set_head(Node* obj){
		assert(c);
		if (c->asConnector()->head->canvas)
			return c->asConnector()->head->canvas->set_player(obj);
	}




	Diagram::Diagram()
	{
		cdiagram = new CDiagram();
		cdiagram->set_player(this);
	}

  //##ModelId=4D81F70C00DA
	void Diagram::add(Node* object){
		nodes.Add(object);
		object->set_context(this);
	}

	//##ModelId=4D81DE0200BB
	void Diagram::edit(){ScreenController::diagram( cdiagram )->Run();}


	//##ModelId=4D81EF4100EA
	void Node::build(){
		Player::build();
		c = new Group(context->cdiagram);
  }

  //##ModelId=4D83B9330177
	void Node::newImage(Upp::Image& image){
		((Group*) c)->addImage(image);
	}
	
	//##ModelId=4D81D5ED01C5
	void Node::newEllipse(double cx,double cy){
		Ellipse* ce = ((Group*) this->c)->addEllipse();
		ce->set_extent(Point(cx,cy));
	}
	
  //##ModelId=4D81D5ED0222
	void Node::newSeparator(){
		((Group*) this->c)->addSeparator();
	}

	//##ModelId=4D81D5ED0186
	void Node::newText(String contents){
		((Group*) this->c)->addText(contents);
	}
	
	//##ModelId=4D81D6A80290
	void Node::border(bool value){
		((Group*) this->c)->bordered = value;
	}



  //##ModelId=4D82069F00BB
	void Arc::startWiring(Node* tail)
	{
		if (tail)
			c->asConnector()->connect(tail->get_group());
		context->get_diagram()->startWiring(c->asConnector());
	}

  //##ModelId=4D837C96008D
	void Arc::connect(Node* n){
		//Canvas* nCanvas = this->context->cdiagram.lookupSole(n);
		this->c->asConnector()->connect(n->c);
	}




} 
