#include "view.h"
#include "player.h"
#include "options.h"

#define IMAGECLASS Images
#define IMAGEFILE <canvas/ui.iml>
#include <Draw/iml_source.h>

namespace cv {

	Upp::Image getImage(Upp::String id){
		return Images::Get(Images::Find(id));
	}

	//##ModelId=4D6056330212
	CanvasCtrl::CanvasCtrl() 
		: Upp::Ctrl()
		, enabled(false)
		, dispatcher(NULL)
		{/**/}
	
	//##ModelId=4D6056330213
	void CanvasCtrl::Paint(Upp::Draw & ws) {
		Upp::Size size=GetSize();
		ImageBuffer ib(size);
		BufferPainter sw(ib, MODE_SUBPIXEL); /*MODE_ANTIALIASED	MODE_NOAA*/
			
		//ws.DrawRect(0,0,size.cx,size.cy,Upp::White);
		sw.Clear(White());
		
		// what does 2000 means ?
		PaintingPainter h(2000, 2000);

		if (enabled)
			dispatcher->doPaint(&h);

		sw.Paint(h);
		ws.DrawImage(0, 0, ib);
		enabled=true; // todo: enabled ge cleared by the container of CanvasView (State)
	}
	
	//##ModelId=4D605633020F
	void CanvasCtrl::dispatch(Event* evt, Upp::dword keyflags){
		evt->key_modifiers = 0;
		if ((keyflags & Upp::K_SHIFT)>0) evt->key_modifiers += K_SHIFT;
		if ((keyflags & Upp::K_CTRL)>0) evt->key_modifiers += K_CONTROL;
		if ((keyflags & Upp::K_ALT)>0) evt->key_modifiers += K_ALT;
		dispatcher->dispatch(evt);
		RefreshLayoutDeep();
	}
	
	//##ModelId=4D6056330215
	void CanvasCtrl::LeftDown(Upp::Point p, Upp::dword keyflags)  { 
		dispatch(new Event(LEFT_DOWN,p.x,p.y),keyflags);
	}

	//##ModelId=4D6056330218
	void CanvasCtrl::LeftDrag(Upp::Point p, Upp::dword keyflags)  { 
		dispatch(new Event(LEFT_DRAG,p.x,p.y),keyflags);
	}

	//##ModelId=4D605633021E
	void CanvasCtrl::LeftUp(Upp::Point p, Upp::dword keyflags)    { 
		dispatch(new Event(LEFT_UP,p.x,p.y),keyflags);
	}

	//##ModelId=4D605633021B
	void CanvasCtrl::MouseMove(Upp::Point p, Upp::dword keyflags) { 
		WhenMouseMove.Execute(Point(p.x,p.y));
		dispatch(new Event(MOUSE_MOVE,p.x,p.y),keyflags);
	}
	
	//##ModelId=4D6056330221
	bool CanvasCtrl::Key(Upp::dword key, int count){
		return true;
	}

	//##ModelId=4D6F495A0139
	void Ruler::Paint(Upp::Draw& d){
		Upp::Size sz=GetSize();
		d.DrawRect(0,0,sz.cx,sz.cy,Upp::White());
		isHorizontal = sz.cx>sz.cy;
		if (isHorizontal){
			d.DrawLine(cursor.x,0,cursor.x,sz.cy,1);
			d.DrawText(cursor.x+3,0,Upp::Format("%2n" ,cursor.x));
			Upp::Font fnt=Upp::StdFont().Height(2);
			for(double xx=0; xx<sz.cx; xx+=100)
			{
				double dist=xx-cursor.x;
				if ((dist>30) || (dist<-30))
				{
					d.DrawLine(xx,0,xx,sz.cy);
					d.DrawText(xx+3,0,Upp::Format("%2n" ,xx));
				}
			}
		}else{
			d.DrawLine(0,cursor.y,sz.cx,cursor.y,1);
			d.DrawText(0,cursor.y+3,Upp::Format("%2n" ,cursor.y));
			for(double yy=0; yy<sz.cy; yy+=100)
			{
				double dist=yy-cursor.y;
				if ((dist>30) || (dist<-30))
				{
					d.DrawLine(0,yy,sz.cx,yy);
					d.DrawText(0,yy+3,Upp::Format("%2n" ,yy));
				}
			}
		}
		
	}
	
	//##ModelId=4D6F495A013B
	void Ruler::set(Point p) {cursor=p; Refresh(); }

	//##ModelId=4D779F490261
	void VBrowser::add(Handler* elt) {
		
		//elt->set_id(Add(elt->get_owner()->get_id(), Images::img_cursor, elt->get_name()));
	}

	//##ModelId=4D77A37E02BF
	void VBrowser::remove(Handler* elt) {
		Remove(elt->get_id());
	}

	//##ModelId=4D77C0C303B9
	void VBrowser::select(Handler* obj) {
		int id=obj->get_id();
		if (id >= 0){
			this->Set(id,Format("%s(%d)",obj->ToString(),id));
			SetCursor(id);
		}
	}

	//##ModelId=4D7767CA02FD
	Halos::Halos() 
		: subject(NULL)
		, last_point(Upp::Point(0,0))
	{/**/}

//##ModelId=4D7F07A60177
	void Halos::show(bool value) {show(last_point,value);}

	//##ModelId=4D77607B03B9
	void Halos::show(Rect area, bool value) {show(area.TopLeft(),value);}
	
//##ModelId=4D7F07A6011D
	void Halos::show(Upp::Point where, bool value) {
		if (value) {
			
			int halosWidth = 250;
			int halosHeight = 24;
			bool halosTransparent = !false;
	
			
			tb->Set(THISBACK(set_toolbar_contents));
			tb->Show();
			tb->Transparent(halosTransparent);
			tb->SetRect( where.x, where.y, halosWidth, halosHeight);
			
		}else{
			tb->Show(false);
		}
	}

	//##ModelId=4D7763FA0242
	void Halos::set_toolbar_contents(Upp::Bar& bar){
		Command* cmd;
		if (subject)		
			for(int i=0; i<subject->get_commands().size(); i++) {
				cmd = subject->get_commands()[i];
				if (subject->canPerform(cmd)){
					if (cmd->img_name != "")
						bar.Add(cmd->description,getImage(cmd->img_name),THISBACK1(send,cmd));
					else
						bar.Add(cmd->description,cmd->image,THISBACK1(send,cmd));
				}
			}
	}

	//##ModelId=4D7767170196
	void Halos::send(Command* cmd) {
		if (subject){
			//show(false);
			cmd->send(subject);
		}
	}

	//##ModelId=4D71C832037A
	void DiagramEditor::set_diagram(CDiagram* diagram){
		subject=diagram;
		browser.set_subject(diagram->get_player());
		fixedHalos.subject = diagram->get_player();
		toolbar.Set(callback(&fixedHalos, &Halos::set_toolbar_contents));
		canvas.dispatcher = &subject->listener;
	}

	//##ModelId=4D77DF65038A
	void DiagramEditor::toggle_limit_halos(){
		Options::showHalosImmediately = !Options::showHalosImmediately;
	}

	//##ModelId=4D6CC59603B9
	DiagramEditor::DiagramEditor(CDiagram* c) 
	{
		//canvas.enabled = false;

		CtrlLayout(*this,"a DiagramEditor");
		Sizeable();
		MaximizeBox().MinimizeBox().Sizeable();
		SetRect(40, 40, 900, 700);
		
		vSplit << browser << docedit;
		vSplit.Vert();

		hSplit << vSplit << canvas;
		hSplit.SetPos(0);
		
		browser.SetRoot(Images::img_cursor,String("diagram"));
		c->get_player()->set_id(0);

		limit_halos <<= THISBACK(toggle_limit_halos);
		limit_halos.Set(true);
		Options::showHalosImmediately = false;
		limit_halos.Tip("\1Show halos only on [/ persistent selections].");
		
		fixedHalos.tb = &toolbar;
		fixedHalos.diagramEditor = this;
		
		Add(float_toolbar);
		floatingHalos.tb = &float_toolbar;
		floatingHalos.diagramEditor = this;
		// its subject is set by HighLight::drawHalos

		set_diagram(c);
		
		//OpenMain();
	}
	
//##ModelId=4D6CC59603AB
#if 0
	LRESULT EditorDialog::WindowProc(UINT message, WPARAM wParam, LPARAM lParam){
		if (displayBuffer != ""){
			w->Title(displayBuffer);
			displayBuffer="";
		}
		return TopWindow::WindowProc(message,wParam,lParam);
	}
#endif	
	// 
  //##ModelId=4D6CC59603BC
	void DiagramEditor::State(int reason){ 
		switch(reason)
		{
			case DEACTIVATE:
			
			case OPEN:
			case CLOSE:
			case ENABLE:
			case SHOW:
			case LAYOUTPOS:
			case ACTIVATE:
			case FOCUS:
				break;
				
			case EDITABLE:
				//canvas.enabled=true;
				//canvas.Refresh();
				break;

			case POSITION:
				canvas.enabled=false;
				break;
		}
	}

	//##ModelId=4D7983DC01CA
	InputBox *ScreenController::inputBox;
	
	//##ModelId=4D71C6C803B9
	cv::DiagramEditor* ScreenController::diagram(cv::CDiagram* c){
		if (!dia_editor)
			dia_editor = new cv::DiagramEditor(c);
		else
			dia_editor->set_diagram(c);
		return dia_editor;
	}

	//##ModelId=4D797C76011F
	cv::DiagramEditor *ScreenController::dia_editor = NULL;

	//##ModelId=4D7921BE0247
	Upp::String ScreenController::input(Upp::String title, Upp::String contents) {
		InputBox w(title,contents);
		w.Run();
		return String("return-value");
	}

	//##ModelId=4D74E7380280
	Handler* View::get_subject() {return subject;}
	
	//##ModelId=4D74E73802A0
	void View::set_subject(Handler* left) {subject = left;}

}



