/*#include <iostream>
using std::cout;*/
#include "assert.h"

#include "canvas.h"
#include "connector.h"
#include "player.h"
#include "view.h"
#include "tools.h"

namespace cv {

	//##ModelId=4D6314460001
	Canvas::Canvas(Canvas* c)
		: Visual()
		, Connectable()
		, owner(c)
		, selected(false)
		, group(NULL)
		, player(Handler::getNullPlayer())
		{
			/**/
		}

	//##ModelId=4D631446000F
	Canvas::Canvas(Canvas* c, float x1, float y1, float x2, float y2)
		: Visual(x1,y1,x2,y2)
		, Connectable()
		, owner(c)
		, selected(false)
		, group(NULL)
		, player(Handler::getNullPlayer())
		{
			/**/
		}

  //##ModelId=4D83AC0D009C
	Handler* Canvas::get_player(){
		return player;
	}
  //##ModelId=4D83AC0D00CB
	void Canvas::set_player(Handler* object){
		player = object;
	}


	//protocol: serialization
	//##ModelId=4D7EC6D5034B
	void Canvas::Serialize(Stream& stream){/**/}

	
	//##ModelId=4D6314460031
	bool Canvas::isConnector(){return false;}
	//##ModelId=4D6314460033
	bool Canvas::isShape() {return false;}
	//##ModelId=4D79238C0228
	bool Canvas::isText(){return false;}
	//##ModelId=4D631446002E
	bool Canvas::isView(){return false;}

	//##ModelId=4D6314460030
	UppCanvas* Canvas::root(){
		return dynamic_cast<UppCanvas*>(view());
	}

	
  
	

	

	

	//##ModelId=4D6C7BD00167
	Canvas* Canvas::view(){
		Canvas* iter;
		assert(owner || isView());
		for(iter=this; !iter->isView(); iter=iter->owner)
			assert(iter->owner != iter);
		return iter;
	}

	
	
	//##ModelId=4D6573DA0167
	int Canvas::get_radius() const {return 0;}
	
	//##ModelId=4D6573DE035B
	void Canvas::set_radius(int left) {throw "error: Canvas cant set radius";}
	

	//##ModelId=4D623EB301F4
	TextStyle::TextStyle()
		: bold(false)
		, underline(false)
	{
	}

	//##ModelId=4D6C566600DA
	void Canvas::setFlag(bool value){
		flag = value;
	}
	
	//##ModelId=4D6C567902DE
	bool Canvas::getFlag(){
		return flag;
	}

	//##ModelId=4D6C7A06009C
	void Canvas::add(Canvas* elt){/**/}

	//##ModelId=4D74A40C00CB
	void Canvas::openInHand(Canvas* c) {/**/}
	void Canvas::open(Canvas* c) {/**/}

	//##ModelId=4D82006E0186
	void Canvas::openInHand() { this->owner->openInHand(this); }
	//##ModelId=4D83D26103D8
	void Canvas::open()       { this->owner->add(this); }


	//##ModelId=4D72EEA5036B
	// alwasy false (since only CDiagram should be answered)
	// todo: check this
	bool Canvas::isDragging() { return false; }

	//##ModelId=4D73BE0B0399
	CDiagram* Canvas::diagram() {
		return dynamic_cast<CDiagram*>(view());
	}

	//##ModelId=4D743F85001F
	void Canvas::beMinimal() {
		for(int i=0; i<incoming.GetCount(); i++) incoming[i]->beMinimal();
		for(int i=0; i<outcoming.GetCount(); i++) outcoming[i]->beMinimal();
	}
	
	//##ModelId=4D743F8F0290
	void Canvas::beNormal() {
		for(int i=0; i<incoming.GetCount(); i++) incoming[i]->beNormal();
		for(int i=0; i<outcoming.GetCount(); i++) outcoming[i]->beNormal();
	}

	//##ModelId=4D7442AD0157
	void Canvas::stopMoving() {
		beNormal();
	}

	//##ModelId=4D74C5E1007D
	void Canvas::remove() {
		for(int i=0; i<incoming.GetCount(); i++) incoming[i]->remove();
		for(int i=0; i<outcoming.GetCount(); i++) outcoming[i]->remove();
		diagram()->remove(this);
	}

	//##ModelId=4D75767F035B
	Connector* Canvas::asConnector() {
		assert(isConnector());
		return dynamic_cast<Connector*>(this);
	}

	//##ModelId=4D7581450290
	Canvas* Canvas::asCanvas() {return this;}

	//##ModelId=4D7F159301B5
	void Canvas::add(Role* obj) {
	}

	//##ModelId=4D7F2CDF00BB
	void Connectable::removeOutcoming(Connector* cn) {
    for(int i=0; i<outcoming.GetCount(); i++)
    	if (outcoming[i] == cn){
    		outcoming.Remove(i);
    		return;
    	}
	}
	
	//##ModelId=4D7F2CE10138
	void Connectable::removeIncoming(Connector* cn) {
    for(int i=0; i<incoming.GetCount(); i++)
    	if (incoming[i] == cn){
    		incoming.Remove(i);
    		return;
    	}
	}
	
	//##ModelId=4D7F2CEA035B
	void Connectable::addIncoming(Connector* cn) {
    for(int i=0; i<incoming.GetCount(); i++)
    	if (incoming[i] == cn) return;
    incoming.Add(cn);
	}
	
	//##ModelId=4D7F2CEF02DE
	void Connectable::addOutcoming(Connector* cn) {
    for(int i=0; i<outcoming.GetCount(); i++)
    	if (outcoming[i] == cn) return;
    outcoming.Add(cn);
	}
	
	//##ModelId=4D7F2D0D005D
	bool Connectable::isConnectedTo(Canvas* c) {return false;}


  //##ModelId=4D7F24E8035B
	Visual::Visual()
		: origin(0,0)
		, extent(0,0)
		, visible(true)
	{}
	
  //##ModelId=4D7F24E8036B
	Visual::Visual(float x1, float y1)
		: origin(x1,y1)
		, extent(0,0)
		, visible(true)
	{}
	
  //##ModelId=4D7F24E803B9
	Visual::Visual(float x1, float y1, float x2, float y2)
		: origin(x1,y1)
		, extent(x2,y2)
		, visible(true)
	{}

	bool cv::Visual::isElastic() {return false;}

	//##ModelId=4D6314460027
	Rect& Visual::bounds() {
			static Rect r;
			const Point& o = get_origin();
			const Point& e = get_extent();
			r.left = (o.x<e.x) ? o.x : e.x;
			r.top = (o.y<e.y) ? o.y : e.y;
			r.right = (e.x>o.x) ? e.x : o.x;
			r.bottom = (e.y>o.y) ? e.y : o.y;
			return r;
	}

	//##ModelId=4D6314460038
	Point const& Visual::get_origin() {return origin;}
	//##ModelId=4D631446003A
	void Visual::set_origin(Point left){origin = left;}

	//##ModelId=4D631446003D
	Point const& Visual::get_extent() {return extent;}
	//##ModelId=4D631446003F
	void Visual::set_extent(Point left){extent = left;}
	//##ModelId=4D6D50A801E4
	void Visual::set_extent(float right,float bottom){ set_extent(Point(right,bottom)); }

	//##ModelId=4D6AA7D3030D
	void Visual::move(Point p){set_origin(p);}
  //##ModelId=4D6C67CC0119
	void Visual::move(float x, float y){set_origin(Point(x,y));}
	//##ModelId=4D6314460029
	void Visual::moveRelative(Point p){
		set_origin(get_origin() + p);
		set_extent(get_extent() + p);
	}

  //##ModelId=4D631446002C
	Point Visual::center(){return bounds().center();}
	
  //##ModelId=4D6314460024
	bool Visual::contains(Point p){ return bounds().Contains(p); }

	//##ModelId=4D7F27B40196
	double Visual::distance(Point p){
		Line l;
		l.start = get_origin();
		l.end = get_extent();
		return l.distance(p);
	}

	//##ModelId=4D6D4A2C000F
	Image::Image(Canvas* owner, Point origin, Upp::Image& _image)
		: Rectangle(owner,origin.x,origin.y,0,0)
		, image(_image)
	{/**/}
	
	//##ModelId=4D6D4A9101C5
	void Image::paint(){
		root()->drawImage(get_origin().x, get_origin().y,image,0);
	}

	//##ModelId=4D6D55F301C5
	Point& Image::get_extent() {
		static Point extent;
		Upp::Size sz = image.GetSize();
		extent.x = get_origin().x+sz.cx;
		extent.y = get_origin().y+sz.cy;
		return extent;
	}

	//##ModelId=4D6D0E82001F
	void CanvasEventListener::dispatch(cv::Event* evt){
		destination->notify(evt);
	}
	
//##ModelId=4D6D11E7030D
	void CanvasEventListener::doPaint(Upp::Painter* p){
		destination->_draw = p;
		destination->paint();
	}

	//##ModelId=4D605633037F
	void UppCanvas::drawCircle(Point center,float radius,int lineWidth,Upp::Color lineColor){
		Upp::Rect r;
		float r2=radius/2;
		_draw->DrawEllipse(center.x-r2/2,center.y-r2/2,r2,r2,lineColor,lineWidth,lineColor);
	}

	//##ModelId=4D6056330384
	void UppCanvas::drawLine(Point start, Point end, int lineWidth, Upp::Color color){
		drawLine(start.x,start.y,end.x,end.y,lineWidth,color);
	}

	//##ModelId=4D6056330389
	void UppCanvas::drawLine(float x1,float y1,float x2,float y2,int lineWidth, Upp::Color color,float angle, float x,float y){
		if (angle==0){
			_draw->DrawLine(x1,y1,x2,y2,lineWidth,color);
		}else{
			Point origin(x,y);
			Point p1(x1,y1);
			Point p2(x2,y2);
			Vect v1(origin,p1);
			Vect v2(origin,p2);
			//float angle_rad = 2*3.14 * angle / 3600;
			float angle_rad = angle;
			v1+=angle_rad;
			v2+=angle_rad;
			float xx1=v1.x(),yy1=v1.y(),xx2=v2.x(),yy2=v2.y();
			
			drawLine(xx1,yy1,xx2,yy2,lineWidth,color);
		}
	}
	
//##ModelId=4D6312F0035B
	void UppCanvas::drawEmptyPoly(Rect& r, int lineWidth, Upp::Color color){
		Upp::Vector<Upp::Point> p;
		int x1=r.left, y1=r.top, x2=r.right, y2=r.bottom;
		p << Upp::Point(x1,y1)
		  << Upp::Point(x2,y1)
		  << Upp::Point(x2,y2)
		  << Upp::Point(x1,y2)
		  << Upp::Point(x1,y1);
		_draw->DrawPolyline(p,lineWidth,color);
	}
	
	//##ModelId=4D6056330393
	void UppCanvas::drawPoly(Rect r, int lineWidth, Upp::Color borderColor, Upp::Color fillColor){
		Upp::Vector<Upp::Point> p;
		int x1=r.left, y1=r.top, x2=r.right, y2=r.bottom;
		p << Upp::Point(x1,y1)
		  << Upp::Point(x2,y1)
		  << Upp::Point(x2,y2)
		  << Upp::Point(x1,y2)
		  << Upp::Point(x1,y1);
		_draw->DrawPolygon(p,fillColor,lineWidth,Upp::Black,/*(uint64)*/0x00000000); //, color, lineWidth, Upp::Black, (uint64)0xaa55aa55aa55aa55, NULL);
	}

	//##ModelId=4D6056330397
	void UppCanvas::drawImage(float x, float y, Upp::Image img, float alpha){
		_draw->DrawImage(x,y,Upp::Rotate(img,alpha));
	}

//##ModelId=4D7B3B34034B
	void UppCanvas::drawImage(float x, float y, Upp::Image img){
		_draw->DrawImage(x,y,img);
	}

	//##ModelId=4D65522300BB
	void UppCanvas::drawRoundRectangle(Rect r, float radius, int lineWidth, Upp::Color borderColor){
		float x1=r.left, y1=r.top;
		float w=r.width(), h=r.height();
		_draw->RoundedRectangle(x1,y1,w,h,radius).Stroke(lineWidth, borderColor);
		
	}

	//##ModelId=4D6228180213
	void UppCanvas::drawText(CText* text)
	{
		Upp::Font font = Upp::StdFont();
#if 0 // USE_SMART_TEXT
		if (text->style.bold) font.Bold();
		if (text->style.underline) font.Underline();
		_draw->DrawSmartText(text->get_origin().x, text->get_origin().y, text->get_contents(),font);
#else
		int cx = 999999;
		Upp::DrawSmartText(*_draw,text->get_origin().x, text->get_origin().y, cx, text->get_contents(),font);
#endif
	}

	//##ModelId=4D622CC50280
	Point UppCanvas::textSize(std::string text)
	{
		
		Point p;
		
		//Upp::Size s = Upp::GetTextSize(text.c_str(),Upp::StdFont(),-1);
		Upp::Size s = GetSmartTextSize(text.c_str(), Upp::StdFont());
		p.x=s.cx;
		p.y=s.cy;
		return p;
	}

	//##ModelId=4D62440D0251
	void UppCanvas::drawEllipse(float x,float y,float cx,float cy,Upp::Color color, int lineWidth)
	{
		_draw->DrawEllipse(x,y,cx,cy,Upp::White,lineWidth,color);
	}
	
	//##ModelId=4D653F700222
	void UppCanvas::setCursor(std::string name){
		Upp::Ctrl::OverrideCursor(getImage(name));
	}

	//##ModelId=4D62461700FA
	Ellipse::Ellipse(Canvas* owner, float x, float y, float cx, float cy)
		: Rectangle(owner,x,y,cx,cy)
	{
	}

	//##ModelId=4D6246B0033C
	void Ellipse::paint()
	{
		int lineWidth = (selected ? 2 : 1);
		root()->drawEllipse(origin.x,origin.y,extent.x,extent.y,Upp::Black,lineWidth);
	}

	//##ModelId=4D6248AC0222
	Point const& Ellipse::get_extent()
	{
		static Point _extent;
		Point& p = (Point&) get_origin();
		_extent.x = p.x + extent.x * 1;
		_extent.y = p.y + extent.y * 1;
		return _extent;
	}

	//##ModelId=4D624B480242
	void Ellipse::moveRelative(Point pt){
		if (getFlag()){
			origin += pt;
			setFlag(false);
		}
	}

	//##ModelId=4D6225CF005D
	CText::CText(Canvas* _owner, float x, float y)
		:Rectangle(_owner,x,y,0,0)
	{
	}

	//##ModelId=4D6C68FB007D
	CText::CText(Canvas* _owner)
		:Rectangle(_owner,0,0,0,0)
	{
	}
	
	//##ModelId=4D62206A0138
	String CText::get_contents() const {
	    return contents;
	}
	
	//##ModelId=4D62206A0157
	void CText::set_contents(String left){
	    contents = left;
	}
	
	//##ModelId=4D6220C600EA
	void CText::paint(){
		//Rectangle::paint();
		style.underline = selected;
		root()->drawText(this);
	}

	//##ModelId=4D622AFE0119
	Point const& CText::get_extent(){
		extent = root()->textSize(get_contents());
		extent += get_origin();
		return extent;
	}

	//##ModelId=4D791FE40053
	void CText::edit(){
	}

	//##ModelId=4D6C6C860280
	void Separator::paint(){
	  float x1,x2,y1,y2;
	  if (horizontal){
	    x1 = group->bounds().left;
	    x2 = group->bounds().right;
	    y1 = get_origin().y;
	    y2 = y1;
	  }else{
	  }
	  root()->drawLine(x1,y2,x2,y2,1);
	}
	
	//##ModelId=4D6C712D02EE
	const Point& Separator::get_extent(){ 
		if (horizontal)
			return get_origin();
		else
			throw "unexpected";
	}

	//##ModelId=4D6C6EEC0000
	bool Separator::isElastic(){return true;}

	//##ModelId=4D6AA64401B5
	Group::Group(Canvas* owner)
		: Canvas(owner)
		, spacing(3)
	{
	}
	
	//##ModelId=4D6AA68400AB
	void Group::paint()
	{
		Point p = get_origin();
		p.y += spacing;
		
		for(int i=0; i<parts.GetCount(); i++){
			parts[i]->move(p);
			parts[i]->paint();
			p.y = parts[i]->get_extent().y + spacing;
		}
		
		if (bordered)
			root()->drawEmptyPoly(bounds(),1);
	}
	
	//##ModelId=4D6AA3B80148
	Rect& Group::bounds(){
		static Rect r;
		r.Set(999999,999999,0,0);
		for(int i=0; i<parts.GetCount(); i++)
			if (!parts[i]->isElastic())
				r+=parts[i]->bounds();
		r += spacing*2;
		return r;
	}
	
	//##ModelId=4D6AA4B4036B
	void Group::add(Canvas* part, Position position){
		/*if (part->group)
			part->group->remove(part);*/
		part->group = this;
		parts.push_back(part);
	}

	//##ModelId=4D6AAC4F0399
	void Group::remove(Canvas* part){
		for(int i=0; i<parts.GetCount(); i++)
			if (parts[i] == part){
				parts.Remove(i);
				break;
			}
	}

	//##ModelId=4D6AADE3008C
	bool Group::isShape(){
		return true;
	}
	
//##ModelId=4D6D4CB203B9
	Image* Group::addImage(Upp::Image& image){
		Image* obj=new Image(owner,Point(0,0),image);
		((CDiagram*)owner->view())->add(obj);
		add(obj);
		return obj;
	}
	
	//##ModelId=4D6C711D01A5
	void Group::addSeparator(){
		add(new Separator(this));
	}

	//##ModelId=4D6C7677032C
	CText* Group::addText(std::string text){
		CText* t=new CText(owner);
		((CDiagram*)owner->view())->add(t);
		add(t);
		t->set_contents(text);
		return t;
	}
	
	//##ModelId=4D6D43760000
	Ellipse* Group::addEllipse(){
		Ellipse* obj=new Ellipse(owner,0,0,40,30);
		((CDiagram*)owner->view())->add(obj);
		add(obj);
		return obj;
	}

	//##ModelId=4D74CE050109
	void Group::remove() {
		for(int i=0; i<parts.GetCount(); i++)
			parts[i]->remove(); // from Diagram, not Group
		parts.Clear();
		Canvas::remove();
	}

	//##ModelId=4D6056330353
	Rectangle::Rectangle(Canvas* c, float x1, float y1, float x2, float y2)
		:Canvas(c,x1,y1,x2,y2)
		,radius(0)
		{/**/}

	//##ModelId=4D605633035A
	bool Rectangle::isShape(){
		return true;
	}

	//##ModelId=4D6056330359
	void Rectangle::paint(){
		int lineWidth = selected?2:1;
		if (radius>0)
			root()->drawRoundRectangle(bounds(),radius,lineWidth);
		else
			root()->drawPoly(bounds(),lineWidth);
	}

	//##ModelId=4D65721B0186
	int Rectangle::get_radius() const{
	    return radius;
	}
	
	//##ModelId=4D65721B01E4
	void Rectangle::set_radius(int left){
	    radius = left;
	}

	//##ModelId=4D605633035D
	void Selection::add(Canvas* c){
		if (!includes(c)){
			
			// A and B are connected by CN, that has way-points
			// just sending moveRelative to A and B does not move waypoints
			// 
			for(int i=0; i<c->outcoming.GetCount(); i++)
				if (includes(c->outcoming[i]->head->canvas))
					add(c->outcoming[i]);
			for(int i=0; i<c->incoming.GetCount(); i++)
				if (includes(c->incoming[i]->tail->canvas))
					add(c->incoming[i]);
			
			elts.Add(c);
			c->get_player()->setSelected(true);
		}
	}
	
//##ModelId=4D73CE4200BB
	void Selection::toggle(Canvas* c){
		if (includes(c))
			remove(c);
		else
			add(c);
	}
	
	//##ModelId=4D745D3801D4
	Canvas* Selection::at(int index){
		if (elts.size() >= index+1)
			return elts[index];
		else
			return NULL;
	}
	
	//##ModelId=4D605633035F
	void Selection::clear(){
		for(int i=0; i<elts.GetCount(); i++)
			elts[i]->get_player()->setSelected(false);
		elts.clear();
	}

	//##ModelId=4D6D591A0203
	void Selection::selectOnly(Canvas* obj, bool bePersistent){
		persistent=bePersistent;
		clear();
		add(obj);
	}
	
	//##ModelId=4D6056330360
	bool Selection::includes(Canvas* c){
		for(int i=0; i<elts.GetCount(); i++)
			if (elts[i] == c) 
				return true;
		return false;
	}
	
	//##ModelId=4D6056330362
	void Selection::moveRelative(Point p){
		for(int i=0; i<elts.GetCount(); i++){
			//elts[i]->beMinimal();
			elts[i]->moveRelative(p);
		}
	}

	//##ModelId=4D7441490271
	void Selection::stopMoving() {
		for(int i=0; i<elts.GetCount(); i++)
			elts[i]->stopMoving();
	}
	
	//##ModelId=4D6056330364
	void Selection::remove(Canvas* c){
		for(int i=0; i<elts.GetCount(); i++)
			if (elts[i] == c){
				elts.Remove(i);
				return;
			}
	}
	
//##ModelId=4D6056330366
	int Selection::size(){
		return elts.GetCount();
	}


//##ModelId=4D605633035C
	Rect Selection::bounds(){
		Rect r(999999,999999,0,0);
		for(int i=0; i<elts.GetCount(); i++)
			r += elts[i]->bounds();
		return r;
	}

	//##ModelId=4D714D5E007D
	Connector* CDiagram::nearestConnector(Point p) {
		Connector* c=NULL;
		double d=999999;
		for(int i=0; i<parts.GetCount(); i++){
			if (parts[i]->isConnector()){
				double d2=parts[i]->distance(p);
				if (d2<d){
					d=d2;
					c = parts[i]->asConnector();
				}
			}
		}
		return c;
	}

	//##ModelId=4D62226901F4
	void CDiagram::initialize()
	{
			tracker = new MTracker(this);
			picker=new MTPick(this);
			relativePicker=new MTPickRelative(this);
			connector=new MTConnect(this);
			dragger=new MTDrag(this);
			highLighter = new HighLight(this);

			add(tracker);
			add(connector);
			add(picker); // must work before MTDrag
			add(relativePicker);
			add(dragger);
			add(highLighter);
	}

	//##ModelId=4D72F02A031C
	bool CDiagram::isDragging(){
		return dragger->state != MTDrag::idle;
	}
	
	//##ModelId=4D6056330237
	CDiagram::CDiagram()
		:Canvas(NULL)
		,UppCanvas(NULL)
		{
			listener.destination=this;
			initialize();
		}

	//##ModelId=4D631B610157
	void CDiagram::moveInFront(Canvas* c){
		for(int i=0; i<parts.GetCount(); i++)
			if (parts[i] == c) {
				parts.Remove(i);
				break;
			}
		parts.Add(c);
	}

	//##ModelId=4D605633023C
	void CDiagram::add(Tool* t){
		tools.push_back(t);
	}

	//##ModelId=4D74A53301A5
	void CDiagram::openInHand(Canvas* c) {
		add(c);
		dragger->startHandling(c);
	}
//##ModelId=4D83D261033C
	void CDiagram::open(Canvas* c) {add(c);}

	//##ModelId=4D605633023E
	void CDiagram::add(Canvas* t){
		for(int i=0; i<parts.GetCount(); i++)
			if (parts[i] == t) return;
		parts.Add(t);
		if (!t->isConnector())
			t->move(tracker->pt);
	}

	//##ModelId=4D605633023B
	void CDiagram::paint(){

		_bounds.Set(999999,999999,0,0);
		_draw->Clear(Upp::White());
		
		for(int i=0; i<parts.GetCount(); i++)
			if (parts[i]->visible && !parts[i]->group){
				parts[i]->paint();
				parts[i]->setFlag(true); // moveRelative avoid multiple dispatch
				_bounds += parts[i]->bounds();
			}
		_bounds += 3;
		
		if (debug.showDiagramBounds){
			_draw->DrawLine(_bounds.left,0,_bounds.left,1000,Upp::PEN_DASH,Upp::WhiteGray());
			_draw->DrawLine(_bounds.right,0,_bounds.right,1000,Upp::PEN_DASH,Upp::WhiteGray());
			_draw->DrawLine(0,_bounds.top,1000,_bounds.top,Upp::PEN_DASH,Upp::WhiteGray());
			_draw->DrawLine(0,_bounds.bottom,1000,_bounds.bottom,Upp::PEN_DASH,Upp::WhiteGray());
		}
		
		for(int i=0; i<tools.GetCount(); i++){
			tools[i]->paint();
		}
			
#if 1
		{
			Canvas* c;
			Point display = Point(3,3);
			Upp::String s = Upp::Format("%d canvas" , (int) parts.size());
			_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
			display.y += 10;
			if (selection.size()>0){
				
				s = Upp::Format("%d selected" , selection.size());
				_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
				display.y += 10;
				
				for(int i=0; i<selection.size(); i++){
					c = selection.at(i);
					
					s = Upp::Format(" - %d %s:%s" 
													, i 
													, (c->isConnector()?"c":"s")
													, ((c->group!=NULL)?"g":"-") 
													);
					_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
					display.y += 10;
				}
				
				if (selection.size() == 1){
					Canvas* c = selection.at(0);
					if (c->isShape()){
						
						s = Upp::Format("%d in, %d out" , (int)c->incoming.size() , (int)c->outcoming.size());
						_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
						display.y += 10;
					}

					s = Upp::Format("id='%s' %d" , String(c->get_player()->ToString()), (int)c->get_player()->get_id());
					_draw->DrawText(display.x,display.y,s,Upp::StdFont(),Upp::Red());
					display.y += 10;
						
				}
			}
		}
#endif
	}
	
	//##ModelId=4D6056330239
	void CDiagram::notify(Event* evt){
		if (evt->isMouseEvent()){
			evt->subjects.clear();
			Canvas* p;
			for(int i=0; i<parts.GetCount(); i++){
				p = parts[i];
				if (p->visible){
					p->selected = p->contains(evt->pt);
					if (p->selected /*&& !p->group*/)
						evt->subjects.Add(p);
				}
			}
			for(int i=0; i<evt->subjects.GetCount(); i++)
				moveInFront(evt->subjects[i]);
		}
		for(int i=0; i<tools.GetCount() && !tools[i]->notify(evt); i++){/**/}
		delete evt;
	}
	
	//##ModelId=4D653E760119
 	void CDiagram::setCursor(std::string name){
		UppCanvas::setCursor(name);
	}

	//##ModelId=4D63F536001F
	void CDiagram::startWiring(Connector* cn){
		add(cn);
		((MTConnect*)connector)->startWiring(cn);
	}

  //##ModelId=4D6CC7C0031C
  void CDiagram::show(){
  }

	//##ModelId=4D713A89030D
	void CDiagram::remove(Canvas* c) {
		for(int i=0; i<parts.GetCount(); i++){
			if (parts[i] == c){
				parts.Remove(i);
				break;
			}
		}
		selection.remove(c);
	}

	//##ModelId=4D711FB20177
	CDiagram::CVDebug::CVDebug()
		: showDiagramBounds(true)
	{/**/}

	//##ModelId=4D7151BC02FD
	void CDiagram::selectConnectorRelativePoint() {
		setCursor("img_label");
		relativePicker->startPickingRelative();
	}

	//##ModelId=4D73BEE4002E
	void CDiagram::selectTree(Canvas* c) {
		Connector* cn;
		for(int i=0; i<parts.GetCount(); i++){
			if (parts[i]->isConnector()){
				cn = parts[i]->asConnector();
				if (!cn->head->isFree())
					if (cn->head->canvas == c)
						selection.add(cn);
				if (!cn->tail->isFree())
					if (cn->tail->canvas == c)
						selection.add(cn);
			}
		}
	}

	//##ModelId=4D74AF9E0119
	void CDiagram::selectAll() {
		for(int i=0; i<parts.GetCount(); i++){
			if (!parts[i]->group)
				selection.add(parts[i]);
		}
		selection.persistent = true;
	}

	//##ModelId=4D74B9B80196
	bool CDiagram::isWiring() {
		return ((MTConnect*) connector)->state != MTConnect::idle;
	}
	
	//##ModelId=4D74D8790138
	bool CDiagram::isPicking() { return relativePicker->isActive(); }

	

	//##ModelId=4D74C0BA02EE
	void CDiagram::clear() {
		while(selection.size())
			selection.at(0)->remove();
	}

	//##ModelId=4D7578BB035B
	Canvas* CDiagram::lookupSole(Handler* m) {
		Canvas* found=NULL;
		for(int i=0; i<parts.GetCount(); i++){
			if (parts[i]->get_player() == m)
				if (found)
					throw "more than one";
				else
					found = parts[i];
		}
		assert(found);
		return found;
	}

}


