#ifndef CLASSDIAGRAM_H_HEADER_INCLUDED_B293786B
#define CLASSDIAGRAM_H_HEADER_INCLUDED_B293786B

#include <CtrlLib/CtrlLib.h>
#include <GridCtrl/GridCtrl.h>
#include <Core/Core.h>
#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#include "canvas/canvas.h"
#include "canvas/player.h"
#include "canvas/view.h"

namespace cv {
	class Command;
	class Connector;
	class ModelEditor;
}

namespace gm {

	Upp::Image getImage(String id);

	class CDBase;
	class CDCommand;
	class CDDiagram;
	class CNode;
	class CArc;
	class Actor;
	class WndEditor;
	class ClassDiagram;

  //##ModelId=4D817DEC0271
  enum CmdType { cmd_clear, cmd_select, cmd_create, cmd_label };
  
	//##ModelId=4D81D29E03D8
  enum NodeType { nt_nil, nt_classdiagram, nt_class, nt_actor, nt_usecase, nt_isa, nt_dep };


	//##ModelId=4D81D8D202CE
	class CDBase
	{
		public:
    //##ModelId=4D81D8D203C9
		String get_name();

    //##ModelId=4D81D8D203CA
		void set_name(String value);
		
    //##ModelId=4D8232B4036B
    NodeType type;
    
	private:

		//##ModelId=4D81D8D203C8
		String name;
	};
	
	



	//##ModelId=4D81C938007D
	class CDDiagram : public CDBase, public cv::Diagram
	{
	public:
		
		//##ModelId=4D81EF410167
		CDDiagram();
		
		// protocol: command
		//##ModelId=4D81F4EB0203
		void perform(cv::Command* cmd);


	};

	//##ModelId=4D81C3BE031C
	class ClassDiagram : public CDDiagram
	{
  public:
		//##ModelId=4D81EF410177
    ClassDiagram()
			: CDDiagram()
		{/**/}
	};

	//##ModelId=4D81C46A038A
	class CNode : public CDBase, public cv::Node
	{
		public:
		
    //##ModelId=4D8201E30251
		void perform(cv::Command* cmd);
	};
	
	//##ModelId=4D81C4BC004E
	class CArc : public CDBase, public cv::Arc
	{
		public:
		/*CArc()
			: CArcT()
		{}*/
	};

	//##ModelId=4D79E489039F
	class Isa : public CArc
	{
	  public:
	  //##ModelId=4D79E54301AB
		void build();
	};
	

	//##ModelId=4D79E48203BE
	class Dep : public CArc
	{
	  public:
		//##ModelId=4D79E5410034
		void build();
		
	};
	

	
	//##ModelId=4D79E479038F
	class Actor : public CNode
	{
		public:
		
		
		//##ModelId=4D79E53E00E0
		void build();
    //##ModelId=4D83E45101E4
    bool canConnectTo(cv::Handler* head, cv::Handler* connector);

	};


	//##ModelId=4D79E45F0228
	class Class : public CNode
	{
		public:
		//##ModelId=4D79E5390295
		void build();
    //##ModelId=4D8313E102BF
    bool canConnectTo(cv::Handler* head, cv::Handler* connector);

		
	};


	//##ModelId=4D79E46A010F
	class Usecase : public CNode
	{
	  public:

		//##ModelId=4D79E53C00D0
		void build();
    //##ModelId=4D83E4560196
    bool canConnectTo(cv::Handler* head, cv::Handler* connector);


	};

}// gm
	
	#define LAYOUTFILE <ClassDiagrams/ui.lay>
	#include <CtrlCore/lay.h>

	#define LAYOUTFILE <ClassDiagrams/pages.lay>
	#include <CtrlCore/lay.h>

	#include "ClassDiagrams/ClassDiagram.h"

namespace gm {

	//##ModelId=4D7B473D008C
	typedef WithClassEditor<TopWindow> WithClassEditor;
	//##ModelId=4D7B9A2A0080
	typedef WithPageProperties<ParentCtrl> WithPageProperties;
	//##ModelId=4D7B9A2A007E
	typedef WithPageMethods<ParentCtrl> WithPageMethods;
	
	//##ModelId=4D7B9A2A007D
	struct Properties : public WithPageProperties
	{
		//##ModelId=4D7B9A2A01A6
		Properties(){CtrlLayout(*this);}
	};	

	//##ModelId=4D7B9A2A006D
	struct Methods : public WithPageMethods
	{
		//##ModelId=4D7B9A2A0198
		Methods(){CtrlLayout(*this);}
	};	

	//##ModelId=4D7B473D009C
	class WndEditor : public WithClassEditor
	{
		//##ModelId=4D7B50E503A9
		typedef WndEditor CLASSNAME;
	
    //##ModelId=4D81D7620158
		CDDiagram* subject;
		
		//##ModelId=4D7B9A2A01A8
		Properties prop_page;
		
		//##ModelId=4D7B9A2A01B6
		Methods meth_page;

		//##ModelId=4D7B473D0198
		WndEditor()
		{
			CtrlLayoutOK(*this,""); 
			ToolWindow();
			
			pages.Add(prop_page,"Properties");
			pages.Add(meth_page,"Methods");
			
			name <<= THISBACK(apply);
		}

		//##ModelId=4D7B4D66032C
		void setSubject(CDDiagram* m);
		
		//##ModelId=4D7B512100EA
		void apply();
	};
	
	//##ModelId=4D7A0ABC0312
	class CDCommand : public cv::Command
	{
		public:
	
		//##ModelId=4D7B9A2A0177
		Upp::Image image;
		
		//##ModelId=4D7A0C010053
		CDCommand(String _img, String _descr, CmdType _ct, NodeType _nt = nt_nil);

		//##ModelId=4D7B9A2A0178
		CDCommand(Upp::Image _img, String _descr, CmdType _ct, NodeType _nt = nt_nil);
		
		//##ModelId=4D817DEC038B
		CmdType cmd_type;
		
    //##ModelId=4D81D586007D
    NodeType node_type;
    
    //##ModelId=4D8375B202DE
    void perform(cv::Player* diagram);

	};
} // namespace gm

#endif

