#ifndef _canvas_Player_h_
#define _canvas_Player_h_

#include "assert.h"

#include <CtrlLib/CtrlLib.h>
using Upp::Callback;

#include "canvas.h"
#include "geometry.h"
#include "player.h"
#include "view.h"
#include "canvas/connector.h"
#include "canvas/Player.h"
#include "canvas/canvas.h"

namespace cv {

	// My predicates tell about what a Model type can do
	//##ModelId=4D81CF7D000F
	class Command
	{
		public:
    //##ModelId=4D81CF7D001F
    enum CommandType {C_clear, C_create, C_all  };

    //##ModelId=4D81CF7D00AB
    Command(Upp::Image _image, String _descr)
			: image(_image)
			, img_name(String(""))
			, description(_descr)
     {/**/}

    //##ModelId=4D81CF7D00AE
    Command(String _image, String _descr)
			: img_name(_image)
			, description(_descr)
     {/**/}
		
    // protocol: command
    //##ModelId=4D81CF7D00B1
    virtual bool canSendTo(Handler* target);
    
    //##ModelId=4D81CF7D00B4
    void send(Handler* aReceiver);
		
    //##ModelId=4D81CF7D009F
		Upp::Image image;
		
    //##ModelId=4D81CF7D00A0
		String description;
		
    //##ModelId=4D81CF7D00A1
		String img_name;
		
    //##ModelId=4D81CF7D00A3
    CommandType cmd_type;
	};

	// - add/remove to/from the VBrowser
	// - VBrowser is obtained thru ScreenController
	//##ModelId=4D6CB1E8032C
	class Handler
	{
		public:
		
    //##ModelId=4D6D66120138
    typedef Array<Command*> CommandVector;

    //##ModelId=4D75CB6902CE
    typedef Array<Handler*> HandlerVector;

    //##ModelId=4D81DD310128
		virtual String ToString(){ return String("an handler"); }
		
    //##ModelId=4D7CEBF00109
		virtual void set_diagram(CDiagram* d){/**/}
		
    //##ModelId=4D7CEBF00167
		virtual CDiagram* get_diagram(){ return NULL; }
		
    //##ModelId=4D7CEBF00177
		virtual Handler* get_owner(){ return NULL; };
    //##ModelId=4D7CEBF00186
		virtual void set_owner(Handler* obj){};
		
    //##ModelId=4D75A3F700AB
    virtual bool isDiagram(){return true;}
    
    //##ModelId=4D75A48D030D
    virtual bool canConnectFrom(Handler* tail);

    //##ModelId=4D6CB37901D4
    virtual bool canConnectTo(Handler* head, Handler* connector);
    
    //##ModelId=4D6CB4E30157
    virtual bool canOwn(Handler* m);
    
    //##ModelId=4D70189D01E4
    virtual void setSelected(bool state);

    //##ModelId=4D7014CF0222
    virtual void edit();
    
    
    // protocol: command
    //##ModelId=4D758F5503D8
    virtual bool canPerform(Command* cmd);
    // protocol: command
    //##ModelId=4D7595BC02EE
    virtual void perform(Command* cmd);

    //##ModelId=4D7719A10157
    virtual CommandVector& get_commands();
    
    //##ModelId=4D7D097A0213
    virtual int get_id();


    //##ModelId=4D7D09800138
    virtual void set_id(int value);
    //##ModelId=4D72845A000F
    static Handler* getNullPlayer();


  protected:
  
    //##ModelId=4D7D052901F5
    static Handler::CommandVector commands;
    
  private:
    // A bulk object that does nothing.
    // avoid NULL check in Canvas
    // 
    // (id = -1) see VBrowser
    // (do not show default players)
    //##ModelId=4D7283B8033C
    static Handler* nullPlayer;

	};

	class Player;
	class Diagram;
	class Node;
	class Arc;
	

	//##ModelId=4D7FD60C0222
	class Player : public Handler
	{
	public:
	
		//##ModelId=4D83B9AA03A9
    Player()
			: c(NULL)
			, context(NULL)
		{/**/}		

		//##ModelId=4D814C3401A5
		virtual bool canConnectTo(Handler* head, Handler* connector);

    //##ModelId=4D83A7710177
		virtual bool canConnectTo(Node* head, Arc* connector);
		
		//##ModelId=4D81720A00EA
		// client-code override and build 
		// the canvas using the methods of Node and Arc
		virtual void build();
		
	public:
    //##ModelId=4D81C0690149
		virtual bool isNode(){return false;}
    //##ModelId=4D81C0690158
		virtual bool isArc(){return false;}
    //##ModelId=4D81C0690168
		virtual bool isDiagram(){return false;}
		
    //##ModelId=4D83E9DB0167
		virtual bool isConnectedTo(Player* object);
		
    //##ModelId=4D837C9601F4
		Node* asNode(){ assert(isNode()); return (Node*) this; }

    //##ModelId=4D824EBD0196
    Diagram* get_context() {return context;}

    //##ModelId=4D824EC5005D
    void set_context(Diagram* _ctx) {
    	context = _ctx;
    	build();
    	c->set_player(this);
    }
    
    //##ModelId=4D825262004E
    void openInHand() {
      if (c && c->isShape())
        c->openInHand();
    }
    
    //##ModelId=4D83D195008C
    void open(){
			if (c) 
				c->open();
		}


    //##ModelId=4D820142034B
    void remove(){if(c) c->remove();}
    
    //##ModelId=4D824F1C03D8
    Canvas* c;

    //##ModelId=4D83A55802FE
    Diagram* context;

	private:
		//##ModelId=4D814AE8030D
		Array<Canvas*> canvas;

	};





	class Node;

	//##ModelId=4D81BF0503D8
	class Diagram : public Player
	{
		public:
		
    //##ModelId=4D81C3540138
		Array<Node*> nodes;

    //##ModelId=4D83A5580252
    CDiagram* cdiagram;

    //##ModelId=4D81C3540148
		Diagram();

    //##ModelId=4D81F70C00DA
		void add(Node* object);
		
    //##ModelId=4D81DE0200BB
		void edit();
		
    //##ModelId=4D8256F8006D
		CDiagram* get_diagram(){ return cdiagram; }
		
		//##ModelId=4D81C091035B
		virtual bool isDiagram() {return true;}
	};


	




	//##ModelId=4D81BF06000F
	class Node : public Player
	{
		public:
		
		//##ModelId=4D81DF12002E
    Node()
    	: Player()
		{/**/}

    //##ModelId=4D8208190167
		Group* get_group(){return (Group*) this->c;}
		
		//##ModelId=4D81C09403C8
		virtual bool isNode() {return true;}

    //##ModelId=4D83B9330177
		void newImage(Upp::Image& image);
    //##ModelId=4D81D5ED0186
		void newText(String contents);
    //##ModelId=4D81D5ED01C5
		void newEllipse(double cx, double cy);
    //##ModelId=4D81D5ED0222
		void newSeparator();
    //##ModelId=4D81D6A80290
		void border(bool value);

		//##ModelId=4D81EF4100EA
		void build();
	};
	





	//##ModelId=4D81BF0503DC
	class Arc : public Player
	{
		public:
		
		//##ModelId=4D8206DC005D
    Arc()
			: Player()
		{/**/}
		
		//##ModelId=4D81C08C029F
		virtual bool isArc() {return true;}
		
    //##ModelId=4D81C18A01D4
		virtual Node* get_tail();
    //##ModelId=4D81C18A01E5
		virtual void set_tail(Node* obj);
		
    //##ModelId=4D81C18A0213
		virtual Node* get_head();
    //##ModelId=4D81C18A0223
		virtual void set_head(Node* obj);
		
    //##ModelId=4D82069F00BB
		virtual void startWiring(Node* tail=NULL);
		
    //##ModelId=4D82554501C5
		void setHeadArrow(ArrowType t){ this->c->asConnector()->head->arrow->type = t; }

    //##ModelId=4D82554501F4
		void setTailArrow(ArrowType t){ this->c->asConnector()->tail->arrow->type = t; }
		
    //##ModelId=4D83072602AF
		void dashed(bool value=true){this->c->asConnector()->dashed = value; }

		//##ModelId=4D825750038A
		virtual void build(){ 
			Player::build();
			c = new Connector( this->context->cdiagram ); 
		}
		
    //##ModelId=4D837C96008D
		virtual void connect(Node* n);

  private:

	};









} // namespace cv

#endif


