#include "FieldOperatorDemo.h"
#include "shared_db.h"

#include "Sql/sch_source.h" // Instantiate all our lovely SqlIds in database.sch

#define SOMENUMBER 1
FieldOperatorDemo::FieldOperatorDemo()
{
	
	if(!session.Open("host=localhost dbname=postgres user=postgres password=postgres"))
	{
		Exclamation(Format("Error in open: %s", DeQtf(session.GetLastError())));
		return;
	}
	
	CtrlLayout(*this, "Window title");

	grid.Appending();
	grid.Removing();
	grid.Editing();
	grid.EditsInNewRow();
	grid.Accepting();
	grid.Moving();
	grid.MovingCols();
	grid.MovingRows();
	grid.Hiding();
	grid.Duplicating();
	grid.Canceling();
	grid.AskRemove();
	grid.Duplicating();
	grid.Searching();
	grid.SearchDisplay();
	grid.SearchImmediate();
	grid.SearchHideRows();
	grid.SearchMoveCursor();
	grid.Closing();
	grid.Inserting();
	grid.RowChanging();
	grid.ResizingRows();
	grid.LiveCursor();
	grid.RejectNullRow(false);
	grid.Clipboard();
	grid.Proportional();
	grid.ColorRows(true);
	grid.FixedPaste();
	grid.CopyColumnNames(true);
	
	grid.AddColumn(TESTID, "Id", 100).Edit(fldTestId);
	grid.AddColumn(TESTNAME, "Name", 100).Edit(fldTestName);
	grid.AddColumn(RELID, "Script").Edit(scriptList).SetConvert(scriptList).Default(-1);
	grid.AddColumn(NOTE, "Note").Edit(fldTestNote);
	grid.AddColumn(CONNID, "Conn").Edit(connList).SetConvert(connList).Default(-1);
	grid.AddColumn(TESTTYPID, "TestType" ).Edit(testTypList).SetConvert(testTypList).Default(-1);
	grid.AddColumn(COMPTYPID, "ComparisonType" ).Edit(compTypList).SetConvert(compTypList).Default(-1);
	grid.AddColumn(X, "X").Edit(fldCompareUsingX);
	grid.AddColumn(Y, "Y").Edit(fldCompareUsingY);
	grid.AddColumn(DESIREDOUTCOME , "Desired Outcome").Edit(desiredOutcomeList).SetConvert(desiredOutcomeList).Default("P");  // P)ass or F)ail
	grid.AddColumn(ACTUALOUTCOME, "Actual Outcome");   // P)ass, F)ail, I)ndeterminate
	grid.AddColumn(OUTPUTVALUE, "Output");
	grid.AddColumn(TASKID, "Task", 50); // The task that owns this test
	grid.AddColumn(PROCESSORDER, "processorder").Hidden();  // Required for ordering
	
	grid.WhenNewRow      = THISBACK(PrepopulateOurNewRow);    // At the creation of a new row; pre-populate fields
	grid.WhenAcceptedRow = THISBACK(SaveOurNewOrEditedRow);   // Build/Run SQL to save data
}

// Callback for  GridCtrl's WhenNewRow.  Called after a new blank row is created.
void FieldOperatorDemo::PrepopulateOurNewRow()
{
	// If we were constructed from some other manager, we would set a real task id to filter
	// our tests for a task.
	// Just an example.
	grid.Set(TASKID, SOMENUMBER);
}

// Callback for populating fields for either insert or update.
void FieldOperatorDemo::FieldLayout(FieldOperator& fo) {
	fo
		(TESTNAME        , grid.Get(TESTNAME))
		(NOTE            , grid.Get(NOTE))
		(RELID           , grid.Get(RELID))
		(CONNID          , grid.Get(CONNID))
		(DESIREDOUTCOME  , grid.Get(DESIREDOUTCOME))
		(ACTUALOUTCOME   , grid.Get(ACTUALOUTCOME))
		(X               , grid.Get(X))
		(Y               , grid.Get(Y))
		(COMPTYPID       , grid.Get(COMPTYPID))
		(TESTTYPID       , grid.Get(TESTTYPID))
		(TASKID          , grid.Get(TASKID))
		(OUTPUTVALUE     , grid.Get(OUTPUTVALUE))
		(PROCESSORDER    , grid.Get(PROCESSORDER))
	;
}

// Callback for  GridCtrl's WhenAcceptedRow.  Called after EndEdit is called when a row is exited.
void FieldOperatorDemo::SaveOurNewOrEditedRow()
{
	int row = grid.GetCursor();
	SqlStatement statement; 
	
	if (grid.IsNewRow()) {
		grid.Set(PROCESSORDER, SOMENUMBER); // Just an example, can calculate a new order value
		statement = SqlStatement(SqlInsert(TESTS)(THISBACK(FieldLayout)));
	} else {
		statement = SqlStatement(SqlUpdate(TESTS)(THISBACK(FieldLayout)).Where(TESTID == grid.Get(TESTID)));
	}

	Sql sql(session);
	
	sql.Execute(statement);
	
	if (grid.IsNewRow()) {
		if (sql.GetRowsProcessed() > 0) {		
			int testid = sql.GetInsertedId(); // Only works if your key or sequence is named "right" :)
			if (testid >= 0) {
				grid.Set(row, TESTID, testid);
			}
		}
	}
}

GUI_APP_MAIN
{
	FieldOperatorDemo().Run();
}

