#ifndef CV_GEOMETRY_H
#define CV_GEOMETRY_H

#include <Draw/Draw.h>
//#include <Core/Core.h>
using Upp::Pointf;
using Upp::Rectf;

namespace cv {

	//##ModelId=4D6056330158
	class Point : public Pointf {
  public:

    //##ModelId=4D65C3AB017C
		Point() :Pointf(){}
    //##ModelId=4D65C3AB019C
		Point(double x,double y) :Pointf(x,y){}
    //##ModelId=4D65DD7D0267
		Point(Upp::Pointf p) :Pointf(p){}
  
	  //##ModelId=4D6056330320
	  Point operator +(double );
	  //##ModelId=4D671153005D
	  Point operator +(Point );

    //##ModelId=4D6056330322
    Point operator -(double);
	  //##ModelId=4D6CC597000F
	  Point operator -(Point );
	  
	  //##ModelId=4D6056330324
	  bool operator==(Point p){ return ((x==p.x) && (y==p.y)); }
	  
	  //##ModelId=4D6056330326
	  double distance(Point other){
	    double xx=other.x-x;
	    double yy=other.y-y;
	    return sqrt(xx*xx+yy*yy);
	  }
	};


	//##ModelId=4D6056330159
	enum Position {North,NorthEast,East,SouthEast,South,SouthWest,West,NorthWest, NearHead, NearTail, NearCenter};
	
	// REFACT Actually I'm a Segment 
	// REFACT and I'm not too far from a Vect
	//##ModelId=4D605633012A
	class Line {
  public:
	  
    //##ModelId=4D60563302D0
    Point start;
    //##ModelId=4D60563302D5
    Point end;
		
    //##ModelId=4D60563302D9
		Line();
    //##ModelId=4D60563302DA
		Line(Point _start, Point _end);
	
	  //##ModelId=4D60563302DD
		double distance(Point& pt);
		
	    //##ModelId=4D646731031C
		double length();
		
		// answer the relative position from ORIGIN
		// of the line's point P' that is nearest to P
		//##ModelId=4D6463DA00AB
		double relative(Point& p);
	
		//##ModelId=4D60563302DF
		bool intersects(Line , Point& );
		//##ModelId=4D608E2D034B
		double alpha();
		
    //##ModelId=4D7D7B4702EE
    Line& operator+=(Point p);
    //##ModelId=4D7D7F010251
    Point relative(double quote);
	};

	//##ModelId=4D65DD7D01F9
	class Rect : public Rectf {
		
	public:

    //##ModelId=4D65DD7D02B6
    Rect() : Rectf() {}
    //##ModelId=4D65DD7D02B7
    Rect(Rect& r) : Rectf(r){}
    //##ModelId=4D65DD7D02B9
    Rect(Point p1, Point p2) : Rectf(p1,p2){}
    //##ModelId=4D65DD7D02BC
    Rect(double l,double t,double r,double b) : Rectf(l,t,r,b){}
    		
    //##ModelId=4D65DD7D02C1
    Point& at(Position c){
      static Point pt;
      switch(c){
        case North: 
        	pt.x=(left+right)/2; 
        	pt.y=bottom;
        	break;
        case NorthEast:
        	pt.x=right;
        	pt.y=bottom;
        	break;
        case East:
        	pt.x=right;
        	pt.y=(top+bottom)/2; 
        	break;
        case SouthEast:
        	pt=Point(right,bottom);
        	break;
        case South:
        	pt.x=(left+right)/2; 
        	pt.y=bottom;
        	break;
        case SouthWest:
        	pt.x=left;
        	pt.y=bottom;
        	break;
        case West:
        	pt.x=left;
        	pt.y=(top+bottom)/2; 
        	break;
        case NorthWest:
        	pt=Point(left,top);
        	break;
      }
      return pt;
    }

    //##ModelId=4D65DD7D02C3
		double width(){ return right - left; }
    //##ModelId=4D65DD7D02C4
		double height(){ return bottom - top; }

    //##ModelId=4D65DD7D02C5
    bool contains(Point p);
    
    //##ModelId=4D65DD7D02C7
    Rect& operator +=(Point p);
    //##ModelId=4D65DD7D02C9
    Rect operator +=(const Rect& );
    //##ModelId=4D72D4B10222
    Rect& operator +=(double );
    //##ModelId=4D65DD7D02CB
    Point center();
    //##ModelId=4D65DD7D02CC
    bool intersectionFrom(Point reference, Point& intersection);
	};

	//##ModelId=4D605633016B
	class Vect
	{
	  //##ModelId=4D605633039C
		bool at_origin;
	  //##ModelId=4D60563303A2
		double alpha;

		public:
	  //##ModelId=4D605633039E
		Point origin;
	  //##ModelId=4D60563303A3
		double radius;
		
		//##ModelId=4D60563303A4
	  Vect();
	
		//##ModelId=4D60563303A5
    Vect(Point zero, double angle, double _radius);

	  //##ModelId=4D6458DD02C1
		Vect(Point zero, Point pt);
		
    //##ModelId=4D6A88A10203
		void rotate(double angle, bool anti = false);
				
    //##ModelId=4D670FA00272
		void set_origin(Point p);
	
    //##ModelId=4D60563303A8
		void set(double x,double y);
		
    //##ModelId=4D67F6BE0290
		void set(Point pt);
		
    //##ModelId=4D68E2A8008C
		void set(Point _origin, Point _extent);
		
    //##ModelId=4D69034B03AA
		Vect& operator=(Vect& rhs);
		
    //##ModelId=4D60563303AB
		Vect& operator+=(double angle);
		
		//##ModelId=4D60563303AD
		double x();
		
		//##ModelId=4D60563303AE
		double y();
		
		//##ModelId=4D645A27000F
		Point asAbsolutePoint();

    //##ModelId=4D6A4C8701F4
    double get_alpha() const;

	
    //##ModelId=4D6A4C870213
    void set_alpha(double left);

	};



} // namespace cv
#endif

