#ifndef _canvas_Tools_h_
#define _canvas_Tools_h_

#include "canvas.h"
#include "geometry.h"

namespace cv {

	class Canvas;
	class CDiagram;
	class Event;
 
	//##ModelId=4D6056330169
	class Tool {
	  public:
	    //##ModelId=4D6056330369
	    bool active;
	
	    //##ModelId=4D605633036B
	    CDiagram* diagram;
	
	    //##ModelId=4D6056330370
	    Point pt;
    //##ModelId=4D74AD4E008C
    bool enabled;

	
	    //##ModelId=4D6056330374
	    Tool(CDiagram* c) 
	    	:	diagram(c) 
	    	, active(false)
	    	, enabled(true)
	    {/**/}
	
	    //##ModelId=4D6056330376
	    virtual bool notify(Event* evt) { return false; };
	
	    //##ModelId=4D6056330379
	    virtual void paint();
	    
		//##ModelId=4D654DB50261
		virtual void finished();
		
    // whether this tool is working or not
    //##ModelId=4D6D1C9400FA
    virtual bool isActive();

    //##ModelId=4D6D1D12031C
    virtual void setActive(bool value);
    //##ModelId=4D74AD6203D8
    void setEnabled(bool value);

	
	};

	//##ModelId=4D6056330157
	class MouseTool : public Tool {
	  public:
	    //##ModelId=4D605633030A
	    MouseTool(CDiagram* c) 
	    	:Tool(c) 
	    	{/**/};
	
	};

	//##ModelId=4D6056330138
	class MTConnect : public MouseTool 
	{
  public:

		//##ModelId=4D6056330139
		enum connectState { idle, wiringTail, leavingTail, wiringHead};

		//##ModelId=4D60563302F0
		MTConnect(CDiagram* c);

    //##ModelId=4D64356A000F
		void startWiring(Connector* c);

		

		//##ModelId=4D60563302F4
		bool notify(Event* evt);

		// event
    // Destroy the connector if wiring didn't finished well
    // (one side was wrong)
    //##ModelId=4D64360A008C
    void abort();

		// event
    // Let the connector survive even if its is free at one side
    //##ModelId=4D613690005D
		void finished();
    //##ModelId=4D76EC5500EA
    void linkToTheNull(Point& p);



		//##ModelId=4D60563302E7
		connectState state;
		//##ModelId=4D60563302EC
		Connector* connector;

	private:


    //##ModelId=4D64356903D9
		Canvas* event_target;
    //##ModelId=4D64356A0001
		Point event_point;

    //##ModelId=4D64356A002E
		void enterState(connectState newState);

    //##ModelId=4D64356A001F
		bool validTarget();


	};

	//##ModelId=4D605633011B
	class HighLight : public Tool 
	{
	public:
		
    //##ModelId=4D746A5102AF
		Upp::Time* tm;
	
    //##ModelId=4D60563302CA
		HighLight(CDiagram* c);
		
		// figure out which should be the performer of a command
		//##ModelId=4D837E5800BB
    Handler* currentSubject();
		
    //##ModelId=4D60563302CC
		void paint();
		
	};

	//##ModelId=4D6056330129
	class KeyboardTool : public Tool {
	};

	//##ModelId=4D772FBB00EA
	class MTracker : public MouseTool
	{
		public:
	    //##ModelId=4D773045037A
			MTracker(CDiagram* c) 
				:MouseTool(c) 
			{}
			
	    //##ModelId=4D7730660213
	    bool notify(Event* evt) {
	      if (evt->tag == MOUSE_MOVE)
	        pt = evt->pt;
	      return false;
	    }
	
	};

	class Canvas;

	//##ModelId=4D6056330148
	class MTDrag : public MouseTool {
	  public:
    //##ModelId=4D74A60D03D8
    enum DragState { dragging, handling, resizing, idle };

    //##ModelId=4D631D32000F
		bool moved;
		
    //##ModelId=4D7445AE035B
		bool clearSelectionWhenFinished;
    //##ModelId=4D74A6590119
    DragState state;

    //##ModelId=4D60563302FF
    MTDrag(CDiagram* c) 
    	:MouseTool(c) 
    	, state(idle)
    	, clearSelectionWhenFinished(false)
    	{};
	
    //##ModelId=4D6056330301
    bool notify(Event* evt);

    //##ModelId=4D654EAE03C8
		void finished();
    //##ModelId=4D74A71901D4
    void startHandling(Canvas* c);
    //##ModelId=4D7B3B900203
    void startResizing(Canvas* c);

  private:
    //##ModelId=4D71176C007D
		void startDragging(Point startPoint);
    //##ModelId=4D71191802EE
		void dragTo(Point endPoint);
    //##ModelId=4D74A7D702DE
    Canvas* handledCanvas;
	};

	class Handler;
	class CDiagram;
	class Event;

	//##ModelId=4D72A62100CB
	class MTPickRelative : public MouseTool
	{
  public:
  
    //##ModelId=4D72AA4B0167
  	MTPickRelative(CDiagram* c);
  
    //##ModelId=4D72A7320157
    bool notify(Event* evt);
    //##ModelId=4D72A7F401A5
    void paint();
    //##ModelId=4D72A82702EE
    void finished();
    // a Model need to pick-up a relative point of some connector
    //##ModelId=4D7144FE00FA
    void startPickingRelative();

  private:
    //##ModelId=4D715E0E007D
    Connector* nearestConnector;

    //##ModelId=4D715E01038A
    Position nearestRelative;
    //##ModelId=4D715FC803C8
    Handler* model;
	};

	// - picking a part of a group means picking the group
	// todo: both pickNull andHighLight show/hide halos
	//##ModelId=4D6056330149
	class MTPick : public MouseTool 
	{
	  public:

		//##ModelId=4D6056330304
		MTPick(CDiagram* c) 
			:MouseTool(c) 
			, pickedConnectorPoint(false)
			, canStartWiring(false)
		{
			
		};
		
    //##ModelId=4D72B10C02EE
		void paint();
	
		//##ModelId=4D6056330306
		bool notify(Event* evt);
    //##ModelId=4D74BD710138
    bool canStartWiring;

  protected:
    //##ModelId=4D72B10C02DE
		bool pickedConnectorPoint;
		
	private:

    //##ModelId=4D73017C007D
		Connector* firstConnector(Event* evt);
		
		//##ModelId=4D6206680271
		bool pickShape(Event* evt, bool persistent);
		
		// pick the background (or the CDiagram if you prefer)
		//##ModelId=4D771DC301A5
    bool pickNull(Event* evt);
		
		//##ModelId=4D62070F01C5
		bool pickConnector(Event* evt);
    //##ModelId=4D72FDDE0000
		bool isNearConnectorHead(Event* evt);
    //##ModelId=4D72FDDE000F
		bool isNearConnectorTail(Event* evt);
		
    
	};

	//##ModelId=4D605633014A
	class MTSelect : public MouseTool {
	};
	

} // namespace cv
#endif
