#ifndef VIEW_H_HEADER_INCLUDED_B28B40A2
#define VIEW_H_HEADER_INCLUDED_B28B40A2

#include <Draw/Draw.h>
#include <CtrlCore/CtrlCore.h>
#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#define IMAGECLASS Images
#define IMAGEFILE <canvas/ui.iml>
#include <Draw/iml_header.h>

#define LAYOUTFILE <canvas/lay2.lay>
#include <CtrlCore/lay.h>

#include "geometry.h"
#include "canvas.h"

namespace cv {

	//##ModelId=4D6D01DE01B5
	typedef WithEditor<TopWindow> WithEditor;
	//##ModelId=4D79806A03AF
	typedef WithTextEditor<TopWindow> WithTextEditor;

	Upp::Image getImage(Upp::String id);

	class CDiagram;
	class DiagramEditor;

	//##ModelId=4D797C750341
	struct InputBox : public WithTextEditor
	{
    //##ModelId=4D797C7600B2
		InputBox(Upp::String title , Upp::String defaultValue){ 
			CtrlLayoutOKCancel(*this,title);
			text.Set(defaultValue);
		}
	};

	//##ModelId=4D71BAD301F4
	class ScreenController
	{
  public:
		
    //##ModelId=4D71C6C803B9
		static DiagramEditor* diagram(CDiagram* c);
		
    //##ModelId=4D7921BE0247
    static Upp::String input(Upp::String title, Upp::String contents);
        
    //##ModelId=4D797C76011F
    static cv::DiagramEditor *dia_editor;

  private:
    //##ModelId=4D7983DC01CA
    static InputBox *inputBox;

	};

	class CanvasEventListener;

	//##ModelId=4D60563300EA
	class CanvasCtrl : public Upp::Ctrl {
	  private:

    //##ModelId=4D605633020F
    void dispatch(Event* evt, Upp::dword keyflags);

	  public:

    //##ModelId=4D70E7E40129
		Upp::Callback1<Point> WhenMouseMove;

    //##ModelId=4D6D0A8200BC
		CanvasEventListener* dispatcher;
    
    //##ModelId=4D605633020E
    bool enabled;

    //##ModelId=4D6056330212
    CanvasCtrl();

    //##ModelId=4D6056330213
    void Paint(Upp::Draw & ws);

    //##ModelId=4D6056330215
    void LeftDown(Upp::Point p, Upp::dword keyflags);

    //##ModelId=4D6056330218
    void LeftDrag(Upp::Point p, Upp::dword keyflags);

    //##ModelId=4D605633021B
    void MouseMove(Upp::Point p, Upp::dword keyflags);

    //##ModelId=4D605633021E
    void LeftUp(Upp::Point p, Upp::dword keyflags);

    //##ModelId=4D6056330221
    bool Key(Upp::dword key, int count);

	};

	//##ModelId=4D6F45630280
	class Ruler : public Upp::Ctrl
	{
		private:
    //##ModelId=4D6F495A0129
		Point cursor;
    //##ModelId=4D6F495A0138
		bool isHorizontal;
		
		public:
    //##ModelId=4D6F495A0139
		void Paint(Upp::Draw& d);
    //##ModelId=4D6F495A013B
		void set(Point p);
		
	};

	// - a diagram has tools
	// - is itself an entity suitable to be represented as a canvas
	//   in some higher level diagram
	//##ModelId=4D7ED8610251
	class VDiagram
	{
	};


	//##ModelId=4D74F5B801F4
	class VText : public Upp::DocEdit
	{
	};

	//##ModelId=4D74E45C00EA
	class View
	{
	  public:
	    //##ModelId=4D779D9D0222
	    enum Event { ADD, REMOVE };
	
	    //##ModelId=4D74E7380280
	    Handler* get_subject();
	
	    //##ModelId=4D74E73802A0
	    void set_subject(Handler* left);
	
	    //##ModelId=4D779CF8037A
	    Handler *subject;
	
	};


	//##ModelId=4D74E3530399
	class VBrowser : public Upp::TreeCtrl, public View
	{
  public:
    //##ModelId=4D779F490261
    void add(Handler* elt);
    //##ModelId=4D77A37E02BF
    void remove(Handler* elt);
    //##ModelId=4D77C0C303B9
    void select(Handler* obj);

	};


	class Handler;
	class Command;
	class DiagramEditor;

	// keep state about halos
	//##ModelId=4D7760120232
	class Halos
	{
		private:
    //##ModelId=4D7F07A60119
		Upp::Point last_point;
		
		public:
		//##ModelId=4D7766CA03C8
		typedef Halos CLASSNAME;

		//##ModelId=4D7767CA02FD
		Halos();

		//##ModelId=4D77625B031D
		DiagramEditor* diagramEditor;
	  
		//##ModelId=4D77607B03B9
		void show(Rect area, bool value = true);
    //##ModelId=4D7F07A6011D
		void show(Upp::Point where, bool value = true);
    //##ModelId=4D7F07A60177
		void show(bool value = true);
		
		//##ModelId=4D77606B02DE
		Handler* subject;
    //##ModelId=4D7761A40213
    Upp::ToolBar *tb;

		
    //##ModelId=4D7767170196
    // send this command to SUBJECT
    // if I'm the one that handles a floating-toolbar 
    // then the subject is set by HighLight
    // 
		void send(Command* cmd);
	
		//##ModelId=4D7763FA0242
		void set_toolbar_contents(Upp::Bar& bar);

	};

	//##ModelId=4D6CC596033E
	class DiagramEditor : public WithEditor
	{
  public:

    //##ModelId=4D7597240272
    VBrowser browser;

    //##ModelId=4D75972402A0
		VText docedit;
    //##ModelId=4D74DEBA009D
		CanvasCtrl canvas;
    //##ModelId=4D74DEBA00BC
		ToolBar float_toolbar;
		
    //##ModelId=4D77614D0001
		Halos fixedHalos;
    //##ModelId=4D776A78007E
		Halos floatingHalos;

    //##ModelId=4D77DF65038A
		void toggle_limit_halos();

    //##ModelId=4D71C832037A
		void set_diagram(CDiagram* diagram);

    //##ModelId=4D6CC59603B9
		DiagramEditor(CDiagram* c);
   
    //##ModelId=4D71A71B037A
    CDiagram *subject;
    //##ModelId=4D79077D019C
    Upp::Option limit_halos;
    //##ModelId=4D79CF91017C
    Upp::Splitter vSplit;


    //##ModelId=4D79077D019C
    //x Upp::Option limit_halos;

		
  private:
    //##ModelId=4D71C3AF01B5
    typedef DiagramEditor CLASSNAME;
		
    //##ModelId=4D6CC59603AA
		void Break(){ exit(0); }


    //##ModelId=4D6CC59603BC
    void State(int reason);
	};

} // namespace cv

#endif /* VIEW_H_HEADER_INCLUDED_B28B40A2 */
