#include "geometry.h"
#include "math.h"

namespace cv {


	Point Point::operator+(double value){
		Point r=*this;
		r.operator+=(value);
		return r;
	}

	//##ModelId=4D6CC597000F
	Point Point::operator -(double value){
		Point r=*this;
		r.operator-=(value);
		return r;
	}

	Point Point::operator+(Point p){
		Point r=*this;
		r.operator+=(p);
		return r;
	}
	Point Point::operator-(Point p){
		Point r=*this;
		r.operator-=(p);
		return r;
	}


	//##ModelId=4D60563302D9
	Line::Line()
		{/**/}
		
	//##ModelId=4D60563302DA
	Line::Line(Point _start,Point _end)
		:start(_start)
		,end(_end)
	{/**/}

	//##ModelId=4D608E2D034B
	double Line::alpha()
	{
		double r = sqrt(pow(start.x-end.x,2) + pow(start.y-end.y,2));
		double alpha = asin((start.y-end.y)/r);
#if 0
		if ((alpha<0) && (alpha >= -2*M_PI))
			return alpha + M_PI;

		if ((alpha>0) && (alpha <= 2*M_PI))
			return alpha - M_PI;

		return alpha;
#else
		double a2=0;
		int sign=1;
		if (start.y < end.y)
			if (start.x < end.x){
				sign = -1;
				a2 = 0;
			}else{
				sign = 1;
				a2 = M_PI;
			}
		else
			if (start.x < end.x){
				sign = -1;
				a2 = 0;
			}else{
				sign = 1;
				a2 = M_PI;
			}
		return sign * alpha + a2;
#endif
	}

	//##ModelId=4D60563302DD
	double Line::distance(Point& pt){
		double x1=start.x;
		double y1=start.y;
		double x2=end.x;
		double y2=end.y;
		double x3=pt.x;
		double y3=pt.y;
		
		double ds = pt.distance(start);
		double de = pt.distance(end);
		
		double area=(x1*y2 +x2*y3 +x3*y1 -x2*y1 -x3*y2 -x1*y3)/2;
		if (area<0) area=-1*area;
		double base = start.distance(end);
		double dl = 2*area/base;
		
		if ((dl<ds) && (dl<de)) return dl;
		if (ds < de) return ds;
		return de;
	}
	
	//##ModelId=4D646731031C
	double Line::length(){
		return start.distance(end);
	}
	
	//##ModelId=4D6463DA00AB
	double Line::relative(Point& p){
		
		double c1_length=distance(p);
		double ip_length=p.distance(start);
		double segment = sqrt(ip_length*ip_length - c1_length*c1_length);

		return segment / length();
	}
	
	//##ModelId=4D60563302DF
	bool Line::intersects(Line l, Point& p){
			double ua,ub;
			double x1=start.x, y1=start.y, x2=end.x, y2=end.y;
			double x3=l.start.x, y3=l.start.y, x4=l.end.x, y4=l.end.y;
			double denom = ((y4-y3)*(x2-x1)-(x4-x3)*(y2-y1));
			ua = ((x4-x3)*(y1-y3) - (y4-y3)*(x1-x3))/denom;
			ub = ((x2-x1)*(y1-y3)-(y2-y1)*(x1-x3))/denom;
			if ((ua<0) || (ua>1) || (ub<0) || (ub>1)) 
				return false;
			p.x= x1+ua*(x2-x1);
			p.y= y1+ua*(y2-y1);
			return true;
	}

	//##ModelId=4D7D7B4702EE
	Line& Line::operator+=(Point p) {
		start += p;
		end += p;
		return *this;
	}

	//##ModelId=4D7D7F010251
	Point Line::relative(double quote) {
		throw "todo merge vector/line";
	}

	//##ModelId=4D65DD7D02C5
	bool Rect::contains(Point p){
		return Rectf::Contains(p);
	}
	
	//##ModelId=4D65DD7D02C9
	Rect Rect::operator+=(const Rect& r){
		Rectf::Union(r);
		return *this;
	}
	
	//##ModelId=4D72D4B10222	
	Rect& Rect::operator+=(double value){
		Rectf::Inflate(value);
		return *this;
	}
	
	//##ModelId=4D65DD7D02C7
	Rect& Rect::operator +=(Point p){
		if (p.x > right) right = p.x;
		if (p.x < left) left=p.x;
		if (p.y > bottom) bottom = p.y;
		if (p.y < top) top = p.y;
		return *this;
	}
	
	//##ModelId=4D65DD7D02CB
	Point Rect::center(){
	 //Pointf p=Rectf::CenterPoint();
	 //return Point(p.x,p.y);
	 return Point(Rectf::CenterPoint());
	}

	//##ModelId=4D65DD7D02CC
	bool Rect::intersectionFrom(Point reference, Point& intersection){
		Line line;
		line.start.x = reference.x;
		line.start.y = reference.y;
		Point c=center();
		line.end.x = c.x;
		line.end.y = c.y;
		
		Line seg1;
		seg1.start.x = left;
		seg1.start.y = top;
		seg1.end.x   = right;
		seg1.end.y   = top;
		if (seg1.intersects(line,intersection)) return true;

		seg1.start.x = right;
		seg1.start.y = top;
		seg1.end.x   = right;
		seg1.end.y   = bottom;
		if (seg1.intersects(line,intersection)) return true;

		seg1.start.x = left;
		seg1.start.y = bottom;
		seg1.end.x   = right;
		seg1.end.y   = bottom;
		if (seg1.intersects(line,intersection)) return true;

		seg1.start.x = left;
		seg1.start.y = top;
		seg1.end.x   = left;
		seg1.end.y   = bottom;
		if (seg1.intersects(line,intersection)) return true;

		return false;			
	}


	//##ModelId=4D60563303A4
  Vect::Vect() 
  	:radius(0)
  	,alpha(0)
		,at_origin(false)
	{/**/}

	//##ModelId=4D60563303A5
  Vect::Vect(Point zero, double angle, double _radius)
		: origin(zero)
		, alpha(angle)
		, radius(_radius)
		, at_origin(false)
	{/**/}

  //##ModelId=4D6458DD02C1
	Vect::Vect(Point zero, Point pt)
		: origin(zero)
	{
		at_origin = (zero==pt);
		if (!at_origin){
			radius=origin.distance(pt);
			alpha=asin((pt.y-origin.y) / radius);
		}
	}

	//##ModelId=4D6A4C8701F4
	double Vect::get_alpha() const {
		return alpha;
	}
	
	//##ModelId=4D6A4C870213
	void Vect::set_alpha(double left) {
	    alpha = left;
	}

//##ModelId=4D6A88A10203
	void Vect::rotate(double angle, bool anti){
		alpha = alpha + (anti ? -angle : angle);
		/*if (alpha < -1 * M_PI/2)
			alpha += 2*M_PI;
		else if (alpha >= 3/2*M_PI)
			alpha -= 2*M_PI;*/
	}

  //##ModelId=4D670FA00272
	void Vect::set_origin(Point p){
		if (p != origin){
			origin=p;
		}
	}

  //##ModelId=4D60563303A8
	void Vect::set(double x,double y){
		set(Point(x,y));
	}

  //##ModelId=4D67F6BE0290
	void Vect::set(Point pt){
		Line l(origin,pt);
		radius = l.length();
		alpha = l.alpha();
	}

  //##ModelId=4D68E2A8008C
	void Vect::set(Point _origin, Point _extent){
		set_origin(_origin);
		set(_extent);
	}
	
  //##ModelId=4D69034B03AA
	Vect& Vect::operator=(Vect& rhs){
		origin = rhs.origin;
		radius = rhs.radius;
		alpha = rhs.get_alpha();
		return *this;
	}

	//##ModelId=4D60563303AB
	Vect& Vect::operator+=(double angle){ 
		alpha+=angle; 
		/////////////////////////////////////////////////// normalize
		return *this;
	}
	
	//##ModelId=4D60563303AD
	double Vect::x(){ 
		if (at_origin)
			return origin.x;
		else
			return origin.x + cos(alpha) * radius; 
	}
	
	//##ModelId=4D60563303AE
	double Vect::y(){ 
		if (at_origin)
			return origin.y;
		else
			return origin.y + sin(alpha) * radius; 
	}

	//##ModelId=4D645A27000F
	Point Vect::asAbsolutePoint(){
		Point p(x(),y());
		/*Upp::StringStream ss;
		ss << "[VECT] " << p.ToString();
		LOG(ss.GetResult());*/
		return p;
	}

}
