#include "tools.h"
#include "connector.h"
#include "player.h"

#include "assert.h"

#include "view.h"
#include "options.h"

namespace cv{
	
  //##ModelId=4D5D6312026A
  void Tool::paint()
  {
  }
	
	//##ModelId=4D654DB50261
	void Tool::finished(){
		diagram->setCursor("img_cursor");
		active = false;
	}

	//##ModelId=4D6D1C9400FA
	bool Tool::isActive() { 
		return active;
	}

	//##ModelId=4D6D1D12031C
	void Tool::setActive(bool value) {
		active=value;
	}

	//##ModelId=4D74AD6203D8
	void Tool::setEnabled(bool value) {enabled=value;}

	//##ModelId=4D60563302F0
	MTConnect::MTConnect(CDiagram* c)
		:MouseTool(c) 
		,connector(NULL)
		,state(idle)
		{/**/}	
		
	//##ModelId=4D64356A000F
	void MTConnect::startWiring(Connector* c){
		connector=c;
		connector->showArrows(false);
		connector->isWiring = true;
		if (connector->tail->isFree())
			enterState(wiringTail);
		else if (connector->head->isFree())
			enterState(wiringHead);
		else
			enterState(idle);
	}

	//##ModelId=4D613690005D
	void MTConnect::finished(){
		connector->showArrows();
		connector->isWiring = false;
		connector=NULL;
		enterState(idle);
		Tool::finished();
	}
	
	//##ModelId=4D64360A008C
	void MTConnect::abort(){
		connector->remove();
		connector=NULL;
		enterState(idle);
	}
	
	// -> event must be already notified
	//##ModelId=4D64356A002E
	void MTConnect::enterState(connectState newState){
		state = newState;
		switch(newState){
			case wiringTail:
				connector->removeSegments();
				connector->beMinimal();
				connector->visible=false;
				connector->tail->beFree(event_point);
				diagram->setCursor("img_wiring_tail");
				break;
			case wiringHead:
				connector->removeSegments();
				connector->beMinimal();
				connector->visible=true;
				connector->head->beFree(event_point);
				diagram->setCursor( "img_wiring_head");
				break;
			case idle:
				// CONNECTOR has yet gone
				diagram->setCursor("img_cursor");
				break;
		}
		if (state != idle)
			if (diagram->selection.size()>0)
				diagram->selection.clear();
	}

	//##ModelId=4D64356A001F
	bool MTConnect::validTarget(){
		if (!event_target) {
			if (state==wiringTail)
				diagram->setCursor("img_wiring_tail");
			else
				diagram->setCursor("img_wiring_head");
			return false;
		}
		if (event_target->isConnectedTo(connector)) {
			if (state==wiringTail)
				diagram->setCursor("img_wiring_tail_veto");
			else
				diagram->setCursor("img_wiring_head_veto");
			return false;
		}
		
		bool r;
		//if (event_target->player && connector->player) // TODO why labels have player==NULL?
		if (state==wiringTail)
			r = connector->get_player()->canConnectFrom(event_target->get_player());
		else
			r = connector->tail->get_canvas()->get_player()->canConnectTo(event_target->get_player(),connector->get_player());
		
		if (r)
			if (state==wiringTail) diagram->setCursor("img_wiring_tail_ok");
			else diagram->setCursor("img_wiring_head_ok");
		else
			if (state==wiringTail) diagram->setCursor("img_wiring_tail_veto");
			else diagram->setCursor("img_wiring_head_veto");
				
		return r;
	}

	//##ModelId=4D76EC5500EA
	void MTConnect::linkToTheNull(Point& p) {
		if (state==wiringTail)
			if (connector->get_player()->canConnectFrom(NULL))
				finished();
			else
				abort();
		else
			if (connector->tail->get_canvas()->get_player()->canConnectTo(NULL,connector->get_player()))
				finished();
			else
				connector->addPoint(p);
	}

	//##ModelId=4D60563302F4
	bool MTConnect::notify(Event* evt)
	{
		event_target = NULL;
		for(int i=0; i<evt->subjects.GetCount(); i++){
			if (evt->subjects[i] != connector){
				event_target = evt->subjects[i];
				break;
			}
		}
		event_point=evt->pt;
		
		if (state == leavingTail){
			if (!event_target)
				enterState(wiringHead);
			return true;
		}
		
		/*
		if (event_target)
			while(event_target->group)
				event_target=event_target->group;
			*/
		
		if (state==idle) return false;
		if (!evt->isMouseEvent()) return false;
		if (!connector) return false;
		
		bool r=false;
		switch(evt->tag)
		{
			case MOUSE_MOVE:
				
				switch(state)
				{
					case wiringTail:
						if (validTarget()){
							if (event_target->isShape()){
								connector->tail->beCentered(event_target);
								diagram->selection.selectOnly(event_target,false);
							}else{
								connector->tail->beRelative(event_target,event_point);
							}
						}else{
							connector->tail->beFree(evt->pt);
						}
						return true;

					case wiringHead:
						if (validTarget()){
							if (event_target->isShape()){
								connector->head->beCentered(event_target);
								diagram->selection.selectOnly(event_target,false);
							}else{
								connector->head->beRelative(event_target,event_point);
							}
							connector->beNormal();
						}else{
							connector->beMinimal();
							connector->head->beFree(evt->pt);
						}
						return true;
				}
				break;
				
			case LEFT_DOWN:
				switch(state){
					case wiringTail:
						if (validTarget()){
							if (event_target->isShape()){
								connector->tail->beCentered(event_target);
								diagram->selection.selectOnly(event_target,false);
							}else{
								connector->tail->beRelative(event_target,event_point);
							}
							connector->beNormal();
							enterState(leavingTail);
							return true;
						} else
							linkToTheNull(evt->pt);
						break;
						
					case wiringHead:
						if (validTarget())
							finished();
						else
							linkToTheNull(evt->pt);
						break;
				}
				return true;
		}
		return false;
	}

  //##ModelId=4D60563302CA
	HighLight::HighLight(CDiagram* c) 
    :Tool(c)
  {
  }

	Handler* HighLight::currentSubject(){
		switch(diagram->selection.size()){
			case 0: 
				return diagram->get_player();
				break;
			case 1:
				return diagram->selection.at(0)->get_player();
				break;
			default:
				return diagram->get_player(); // todo: is it true?
				break;
		}
	}

	//##ModelId=4D60563302CC
  void HighLight::paint() {
    if (diagram->selection.size() >0){
      if (!diagram->isDragging()){
				Rect r;
				r=diagram->selection.bounds();
				r += 6;
				
				Halos& h = ScreenController::dia_editor->floatingHalos;
				h.subject = currentSubject();
				h.show(r,
					!diagram->isWiring()
		  		&& !diagram->isPicking()
		  		&& (diagram->selection.persistent || Options::showHalosImmediately)
		  	);
				
				int width = diagram->selection.persistent ? 3:2;
				
				int radius=6;
				Upp::Color color = Upp::Cyan;
				if (diagram->picker->canStartWiring){
	        color = Upp::Red();
	        width = 3;
	      }
	      
	      diagram->drawRoundRectangle(r,radius,width,Upp::Blend(color,Upp::White(),100));
	      Point p;
			}
		}
	}

	//##ModelId=4D654EAE03C8
	void MTDrag::finished(){
		if (state == dragging)
			diagram->selection.stopMoving();
		state = idle;
		if (clearSelectionWhenFinished){
			diagram->selection.clear();
			clearSelectionWhenFinished = false;
		}
		Tool::finished();
	}
	
	//##ModelId=4D71176C007D
	void MTDrag::startDragging(Point startPoint){
		pt=startPoint;
		state = dragging;
		setActive(true);
		moved=false;
		ScreenController::dia_editor->floatingHalos.show(false);
	}


	//##ModelId=4D7B3B900203
	void MTDrag::startResizing(Canvas* c) {
		handledCanvas = c;
		state = resizing;
	}

	//##ModelId=4D74A71901D4
	void MTDrag::startHandling(Canvas* c) {
		handledCanvas = c;
		handledCanvas->beMinimal();
		handledCanvas->move(diagram->tracker->pt);
		state = handling;
	}
	
	//##ModelId=4D71191802EE
	void MTDrag::dragTo(Point endPoint){
		moved=true;
		Point delta;
		if (endPoint != pt){
	  	delta=endPoint - pt;
	  	diagram->selection.moveRelative(delta);
	  	pt=endPoint;
		}
	}
	
	//##ModelId=4D6056330301
  bool MTDrag::notify(Event* evt){ 

    if (!evt->isMouseEvent())
      return false;
    
		switch(state){
			case resizing:
				switch(evt->tag){
					case MOUSE_MOVE:
						handledCanvas->set_extent(evt->pt);
						return true;
					case LEFT_UP:
						finished();
						return false;
				}
				return false;
				
			case dragging:
				switch(evt->tag){
      		case LEFT_UP:
      			if (moved)
							if (diagram->selection.size() == 1)
								// clear selection at the end of a dragging session 
								// if only one canvas was selected
								clearSelectionWhenFinished = true;
						finished();
						return false;
					case MOUSE_MOVE:
						dragTo(evt->pt);
				  	return true;
				}

			case handling:
				switch(evt->tag){
					case LEFT_DOWN:
						handledCanvas->beNormal();
						handledCanvas=NULL;
						state = idle;
						return false;
					case MOUSE_MOVE:
						handledCanvas->move(evt->pt);
						return true;
					default:
						return false;
				}
				
			case idle:
				switch(evt->tag){
					case LEFT_DOWN:
						if (diagram->selection.bounds().contains(evt->pt)){
							startDragging(evt->pt);
							return true;
						}
				}
				return false;
		}
		return false;
  }

	//##ModelId=4D72AA4B0167
	MTPickRelative::MTPickRelative(CDiagram* c)
		:MouseTool(c)
	{/**/}

	//##ModelId=4D72A7320157
	bool MTPickRelative::notify(Event* evt) {
    if (!evt->isMouseEvent() || !isActive())
      return false;

    switch(evt->tag)
    {
      case LEFT_DOWN:
    		finished();
    		return false;

      case MOUSE_MOVE:
    		nearestConnector = diagram->nearestConnector(evt->pt);
    		if (nearestConnector){
    			diagram->selection.selectOnly(nearestConnector,true);
    			Point pH = nearestConnector->relative(NearHead).asAbsolutePoint();
    			Point pC = nearestConnector->relative(NearCenter).asAbsolutePoint();
    			Point pT = nearestConnector->relative(NearTail).asAbsolutePoint();
    			double dH = evt->pt.distance(pH);
    			double dC = evt->pt.distance(pC);
    			double dT = evt->pt.distance(pT);
    			if (dH < dC) {
    				pt=pH;
    				nearestRelative = NearHead;
    			} else {
    				if (dT < dC){
    					pt=pT;
    					nearestRelative = NearTail;
    				} else {
    					pt=pC;
    					nearestRelative = NearCenter;
    				}
    			}
    			return true;
    		} else {
    			// no connectors in the view
    			finished();
    			return false;
    		}
		}
		return false;
	}

	//##ModelId=4D72A7F401A5
	void MTPickRelative::paint() {
		if (isActive())
			diagram->root()->drawCircle(pt,12,2,Upp::Red());
	}

	//##ModelId=4D72A82702EE
	void MTPickRelative::finished() {
		diagram->picker->setEnabled(true);
		setActive(false);
		if (nearestConnector){
			Canvas* c = nearestConnector->addLabel("ABC",nearestRelative);
			//c->set_origin(diagram->tracker->pt);
			c->moveRelative( diagram->tracker->pt - c->get_origin() );
		}
		diagram->selection.clear();
		diagram->setCursor("img_cursor");
	}

	//##ModelId=4D7144FE00FA
	// todo: just a spike, should return a connector and a relative
	// instead of performing all the job
	void MTPickRelative::startPickingRelative() {
		diagram->picker->setEnabled(false);
		setActive(true);
	}

	//##ModelId=4D6206680271
	bool MTPick::pickShape(Event* evt, bool persistent)
	{
		Canvas* pick_subject;

		pick_subject = evt->subjects.back();

		// Diagram::paint discard group-components
		//assert(!pick_subject->group);

		switch(evt->key_modifiers){
	    case 0:
	      diagram->selection.clear();

	    case K_CONTROL:
	    	diagram->selection.toggle(pick_subject);
	      break;

	    case K_ALT + K_CONTROL:
	    	diagram->selection.toggle(pick_subject);
	    	for(int i=0; i<pick_subject->incoming.GetCount(); i++)
	    		diagram->selection.toggle(pick_subject->incoming[i]);
	    	for(int i=0; i<pick_subject->outcoming.GetCount(); i++)
	    		diagram->selection.toggle(pick_subject->outcoming[i]);
	    	break;
	    	
	  }
	  diagram->selection.persistent=persistent;
		return false;
	}

	//##ModelId=4D72B10C02EE
	void MTPick::paint(){
	}

//##ModelId=4D73017C007D
	Connector* MTPick::firstConnector(Event* evt){
		if (evt->subjects.IsEmpty()) 
			return NULL;
		if (evt->subjects.back()->isConnector())
			return evt->subjects.back()->asConnector();
		else
			return NULL;
	}

	//##ModelId=4D72FDDE0000
	bool MTPick::isNearConnectorHead(Event* evt){
		Connector* cn = firstConnector(evt);
		if (!cn) return false;
		return (cn->head->point().distance(evt->pt) < 12);
	}
	
	//##ModelId=4D72FDDE000F
	bool MTPick::isNearConnectorTail(Event* evt){
		Connector* cn = firstConnector(evt);
		if (!cn) return false;
		return (cn->tail->point().distance(evt->pt) < 12);
	}

	//##ModelId=4D771DC301A5
	//
	// 1st click on the background clear selection and hide halos
	// a 2nd one get-up the halos
	//
	bool MTPick::pickNull(Event* evt)
	{
		if (!diagram->selection.isEmpty()) {
			diagram->selection.clear();
			ScreenController::dia_editor->floatingHalos.show(false);
		}else{
			ScreenController::dia_editor->floatingHalos.show(evt->pt,true);
			ScreenController::dia_editor->floatingHalos.subject = diagram->get_player();
		}
		return true;
	}

	//##ModelId=4D62070F01C5
	bool MTPick::pickConnector(Event* evt)
	{
		Connector* cn=firstConnector(evt);
		//assert(cn!=NULL);
		
		//Point cp=cn->relative(cn->relative(evt->pt));
		Point cp = evt->pt;
		if (cp == pt){
			// second hit over the same point of a connector
			// (we assume the connector of previuos hit was this same connector)
			pickedConnectorPoint=true;
			cn->addPoint(pt);
			cn->setActiveSegment(pt);
			return false;
		} else {
			pt=cp;
			pickedConnectorPoint=false;
		}
		
		// pick-up the head/tail of a connector
		if (cn->head->point().distance(evt->pt) < 12){
			cn->head->beFree(evt->pt);
			diagram->startWiring(cn);
			return true;
		} else if (cn->tail->point().distance(evt->pt) < 12){
			cn->tail->beFree(evt->pt);
			diagram->startWiring(cn);
			return true;
		}
		return false;
	}
	


  //##ModelId=4D6056330306
	bool MTPick::notify(Event* evt){ 
    if (!evt->isMouseEvent())
      return false;

    switch(evt->tag)
      {
      case LEFT_DOWN:
				if (evt->subjects.IsEmpty() && !diagram->selection.bounds().contains(evt->pt))
			  	return pickNull(evt);
				
			 	if (evt->subjects.IsEmpty())
			 		return false;
			 	
			 	if (!evt->subjects.back()->isConnector())
			 		if (evt->pt.distance(diagram->selection.bounds().at(SouthEast)) < 8){
			 			diagram->dragger->startResizing(evt->subjects.back());
			 			return true;
			 		}
			 	
		    if (evt->subjects.back()->isConnector())
	        if (pickConnector(evt))
	        	return true;
	        
				return pickShape(evt,true);

      case MOUSE_MOVE:
      	if (!enabled)
      		return false;
      	
      	if (!diagram->dragger->isActive()
      	    && !diagram->selection.persistent || (diagram->selection.size()==0))
      	{
      		if (isNearConnectorHead(evt)){
						diagram->setCursor("img_wiring_head");
						canStartWiring = true;
      		}else{
						if (isNearConnectorTail(evt)){
							diagram->setCursor("img_wiring_tail");
							canStartWiring = true;
						}else{
							diagram->setCursor("img_cursor");
							canStartWiring = false;
						}
      		}
						
					if (evt->subjects.IsEmpty() && !diagram->selection.bounds().contains(evt->pt)){
					  if (!diagram->selection.persistent) {
					  	diagram->selection.clear();
					  }
					}else
						if (!evt->subjects.IsEmpty())
							if (!diagram->selection.includes(evt->subjects.back()))
		      			return pickShape(evt,false);
      	}
		}
    return false;
  }


}
