#include "classDiagram.h"
#include "assert.h"

#include "canvas/canvas.h"
#include "canvas/connector.h"
#include "canvas/view.h"
#include "canvas/player.h"

#define IMAGECLASS CDImages
#define IMAGEFILE <ClassDiagrams/ui.iml>
#include <Draw/iml.h>

namespace gm {

	Upp::Image getImage(String id){
		return CDImages::Get(CDImages::Find(id));
	}

	//##ModelId=4D81EF410167
  	CDDiagram::CDDiagram()
	{
		
		
		#if 1
		if (commands.GetCount() == 0){
			commands.Add(
			               new CDCommand(getImage("img_class")
			                             ,"class"
			                             ,cmd_create
			                             ,nt_class));
			commands.Add(
			               new CDCommand(getImage("img_usecase")
			                             ,"usecase"
			                             ,cmd_create
			                             ,nt_usecase));
			commands.Add(
			               new CDCommand(getImage("img_actor")
			                             ,"actor"
			                             ,cmd_create
			                             ,nt_actor));
			commands.Add(
			               new CDCommand(getImage("img_isa")
			                             ,"isa"
			                             ,cmd_create
			                             ,nt_isa));
			commands.Add(
			               new CDCommand(getImage("img_dep")
			                             ,"dep"
			                             ,cmd_create
			                             ,nt_dep));
			commands.Add(
			               new CDCommand(getImage("img_label")
			                             ,"add a label"
			                             ,cmd_label));
			commands.Add(
			               new CDCommand(getImage("img_all")
			                             ,"all"
			                             ,cmd_select));
			commands.Add(
			               new CDCommand(getImage("img_clean")
			                             ,"clear"
			                             ,cmd_clear));
			commands.Add(
			               new CDCommand(getImage("img_pop")
			                             ,"populate"
			                             ,cmd_populate));
			commands.Add(
			               new CDCommand(getImage("img_stress")
			                             ,"stress"
			                             ,cmd_stress));
		}
		#endif
	}
	
	
  //##ModelId=4D81F4EB0203
  void CDDiagram::perform(cv::Command* cmd){ ((CDCommand*)cmd)->perform(this); }
  
//##ModelId=4D84BEC800CB
  void CDDiagram::stress(){
    populate();
    cdiagram->selectAll();
    cdiagram->clear();
  }
  
	//##ModelId=4D84A8FC008C
  void CDDiagram::populate(){
    
    Array<CNode*> g;
		CNode* n;
		int i,x,y;
		
		for(i=0; i<50; i++){
	    n = new Class();
	    g.Add(n);
	    n->type = nt_class;
	    n->set_name(Format("node %d",i));
	    add(n);
	    x = Random(600);
	    y = Random(600);
	    n->c->move(x,y);
		}
		
		CNode* n1;
		CNode* n2;
		for(i=0; i<50; i++){
			n1 = g[Random(50)];
			n2=n1;
			while(n1==n2)
				n2 = g[Random(50)];
			switch(Random(2)){
				case 0:
					n1->isa(n2);
					break;
				case 1:
					n1->depends(n2);
					break;
			}
		}

  }
	



  //##ModelId=4D81D8D203CA
	void CDBase::set_name(String value){name = value;}

  //##ModelId=4D81D8D203C9
	String CDBase::get_name(){ return name; }



	//##ModelId=4D7B4D66032C
	void WndEditor::setSubject(CDDiagram* m){
		subject = m;
		if (m){
			switch(m->type){
				case nt_class:
					name.Set(m->get_name());
					break;
			}
		} else {
			name.Set(String(""));
		}
	}

	//##ModelId=4D7B512100EA
	void WndEditor::apply(){
		if (subject){
			subject->set_name(name.Get());
		}
	}

	//##ModelId=4D7A0C010053
	CDCommand::CDCommand(String _img, String _descr, CmdType _ct, NodeType _nt) 
		: Command(_img,_descr)
		, cmd_type(_ct)
		, node_type(_nt)
	{/**/}

	//##ModelId=4D7B9A2A0178
	CDCommand::CDCommand(Upp::Image _img, String _descr, CmdType _ct, NodeType _nt) 
		: Command(_img,_descr)
		, cmd_type(_ct)
		, node_type(_nt)
	{/**/}

	//##ModelId=4D79E53E00E0
	void Actor::build() {
		static Upp::Image _img = CDImages::actor();
		Node::build();
		newImage(_img);
		newText(get_name());
		border(false);
	}

	//##ModelId=4D79E5390295
	void Class::build(){
		Node::build();
		
		newText(Format("\1[* %s]" , get_name()));
		/*newSeparator();
		newText("- properties");
		newSeparator();
		newText("- methods");*/
	}

	//##ModelId=4D8313E102BF
	// here you get a pointer to your root class, but you need the framework's one
	bool Class::canConnectTo(cv::Handler* head, cv::Handler* connector) {
		CArc* arc = (CArc*) connector;
		CNode* h = (CNode*) head;
		if (!head){
			if (arc->type == nt_isa) {
				Class* super = new Class();
				super->set_name("a super");
				get_context()->add(super);
				arc->connect(super);
				//super->open();
				return true;
			} else
				return false;
		} else {
			switch(arc->type){
				case nt_dep:
					if (h->type == nt_class) return true;
					if (h->type == nt_actor) return true;
					if (h->type == nt_usecase) return false;
					break;
				case nt_isa:
					if (h->type == nt_class) return !h->isConnectedTo(this);
					if (h->type == nt_actor) return true;
					if (h->type == nt_usecase) return false;
					break;
			}
		}
		return true;
	}

	//##ModelId=4D83E4560196
	bool Usecase::canConnectTo(cv::Handler* head, cv::Handler* connector) {
		CArc* arc = (CArc*) connector;
		CNode* h = (CNode*) head;
		CNode* newnode=NULL;
		if (head==NULL){
			switch(arc->type){
				case nt_isa:
				case nt_dep:
					newnode = new Usecase();
					break;
			}
			if (!newnode)
				return false;
			get_context()->add(newnode);
			arc->connect(newnode);
			//newnode->open();
			return true;
		} else {
			switch(arc->type){
				case nt_dep:
					if (h->type == nt_class) return false;
					if (h->type == nt_actor) return false;
					if (h->type == nt_usecase) return true;
					break;
				case nt_isa:
					if (h->type == nt_class) return false;
					if (h->type == nt_actor) return false;
					if (h->type == nt_usecase) return true;
					break;
			}
		}
		return true;
	}

	//##ModelId=4D83E45101E4
	bool Actor::canConnectTo(cv::Handler* head, cv::Handler* connector) {
		CArc* arc = (CArc*) connector;
		CNode* newnode=NULL;
		CNode* h = (CNode*) head;
		if (!head){
			switch(arc->type){
				case nt_dep:
					newnode = new Usecase();
					break;
				case nt_isa:
					newnode = new Actor();
					break;
			}
			if (newnode){
				get_context()->add(newnode);
				arc->connect(newnode);
				//newnode->open();
				return true;
			}
			return false;
		} else {
			switch(arc->type){
				case nt_dep:
					if (h->type == nt_class) return false;
					if (h->type == nt_actor) return false;
					if (h->type == nt_usecase) return true;
					break;
				case nt_isa:
					if (h->type == nt_class) return true;
					if (h->type == nt_actor) return true;
					if (h->type == nt_usecase) return false;
					break;
			}
		}
		return true;
	}

	//##ModelId=4D79E5410034
	void Dep::build() {
		Arc::build();
		setHeadArrow(cv::OpenArrow);
		dashed();
	}

	//##ModelId=4D79E54301AB
	void Isa::build() {
		Arc::build();
		setHeadArrow(cv::ClosedEmpty);
	}

	//##ModelId=4D79E53C00D0
	void Usecase::build() {
		Node::build();
		border(false);
		newEllipse(40,20);
		newText("\1a [/ usecase]");
	}

	//##ModelId=4D8201E30251
	void CNode::perform(cv::Command* cmd){ ((CDCommand*)cmd)->perform(this); }

	//##ModelId=4D8375B202DE
  void CDCommand::perform(cv::Player* performer)
  {
    CDDiagram* dia;
    if (performer->isDiagram())
    	dia = (CDDiagram*) performer;
    else
      dia = (CDDiagram*) performer->get_context();
    
    switch(cmd_type){
			case cmd_populate:
				dia->populate();
				break;
			case cmd_stress:
				dia->stress();
				break;
      case cmd_label:
      	dia->cdiagram->selectConnectorRelativePoint();
      	break;
      case cmd_clear:
      	dia->cdiagram->clear();
      	break;
      case cmd_select:
      	dia->cdiagram->selectAll();
      	break;
      case cmd_create:
	    {
		    CNode* n = NULL;
		    CArc* a = NULL;
		    switch(node_type)
		    {
		      case nt_class:
		      	n = new Class();
		      	break;
		      case nt_usecase:
		      	n = new Usecase();
		      	break;
		      case nt_actor:
		      	n = new Actor();
		      	break;
		      case nt_isa:
		      	a = new Isa();
		      	break;
		      case nt_dep:
		      	a = new Dep();
		      	break;
		    }
				if (n)
				{
		      n->type = node_type;
		    	n->set_name("Foo");
		    	dia->add(n); // triggers Node::build (all data must be set)
		    	n->openInHand();
		    }
		    if (a)
		    {
		      a->type = node_type;
		      a->set_context(dia);
		      dia->add(a);
		      if (performer->isNode())
		        a->connect(performer->asNode());
		      a->startWiring();
		    }
	    }
    }
  }
  
	void CNode::isa(CNode* object){
		CArc* a = new Isa();
		context->add(a);
		a->connect(this);
		a->connect(object);
	}
	
	void CNode::depends(CNode* object){
		CArc* a = new Dep();
		context->add(a);
		a->connect(this);
		a->connect(object);
	}
  
  
}
