#ifndef CV_CANVAS_H
#define CV_CANVAS_H

#include "assert.h"

#include <Painter/Painter.h>
#include <CtrlLib/CtrlLib.h>
using Upp::Array;
using Upp::Stream;
using Upp::String;

#include "geometry.h"
#include "canvas/canvas.h"

namespace cv {

	class Canvas;
	class Connector;

	//##ModelId=4D7F2C9C01E4
	class Connectable
	{
	  public:
	    //##ModelId=4D63144502FE
	    typedef Array<Canvas*> CanvasVector;
	
	    // remove link Canvas/Connector not the Connector itself
	    //##ModelId=4D7F2CDF00BB
	    void removeOutcoming(Connector* cn);
	
	    // remove link Canvas/Connector not the Connector itself
	    //##ModelId=4D7F2CE10138
	    void removeIncoming(Connector* cn);
	
	    //##ModelId=4D7F2CEA035B
	    void addIncoming(Connector* cn);
	
	    //##ModelId=4D7F2CEF02DE
	    void addOutcoming(Connector* cn);
	
	    //##ModelId=4D7F2D0D005D
	    virtual bool isConnectedTo(Canvas* c);
	
	    // a list of connectors having HEAD attached to this canvas
	    //##ModelId=4D7F455900CB
	    Array<Connector*> incoming;
	
	    // a list of connectors having TAIL attached to this canvas
	    //##ModelId=4D7F455900CC
	    Array<Connector*> outcoming;
  protected:
    //##ModelId=4D84AB7100DA
    void remove();
  private:

	};


//##ModelId=4D85CB86032C
	class Container
	{
  public:
  
    // add a canvas
    //##ModelId=4D85CD4E002E
    void add(Canvas* elt);

    //##ModelId=4D85CE67002E
    bool includes(Canvas* obj);
    
    //##ModelId=4D85D6710196
    void removeParts();
    
    //##ModelId=4D85EDE6002E
    virtual void remove(Canvas* part);


    //##ModelId=4D85CC7F0167
    Array<Canvas*> parts;

	};


	// Characteristics that affects the visualization
	//##ModelId=4D7F19B80399
	class Visual
	{
	  public:
  
    //##ModelId=4D7F24E8035B
  	Visual();
    //##ModelId=4D7F24E8036B
  	Visual(float x1, float y1);
    //##ModelId=4D7F24E803B9
  	Visual(float x1, float y1, float x2, float y2);
  
    //##ModelId=4D6314460027
    virtual Rect& bounds();
    //##ModelId=4D6439280280
    bool visible;

    // Separator are elastic
    // (Group does not try to compute elastic canvas size)
    //##ModelId=4D6C6E3C0109
    virtual bool isElastic();

    //##ModelId=4D6AA7D3030D
    virtual void move(Point p);
    //##ModelId=4D6C67CC0119
    virtual void move(float x, float y);
    //##ModelId=4D6314460029
    virtual void moveRelative(Point);

    //##ModelId=4D6314460024
    virtual bool contains(Point p);
    //##ModelId=4D631446002C
    virtual Point center();
    
    //##ModelId=4D6314460038
    virtual Point const& get_origin();
    //##ModelId=4D631446003A
    virtual void set_origin(Point left);

    //##ModelId=4D631446003D
    virtual Point const& get_extent();
    //##ModelId=4D631446003F
    virtual void set_extent(Point left);
    //##ModelId=4D6D50A801E4
    virtual void set_extent(float right, float bottom);
    
    //##ModelId=4D7F27B40196
    virtual double distance(Point p);

    // - each canvas must implement its paint
    // 
    // - CDiagram does all its computations during paint
    //   not all computation really need to be done in paint
    // 
    // - Group's paint themself and their children
    //   (children are owned both by CDiagram and Group)
    //##ModelId=4D6314460022
    virtual void paint() = 0;


  protected:
    //##ModelId=4D7F241C01D6
    Point origin;
    //##ModelId=4D7F241F02F0
		Point extent;
	};
	
	class Connector;
	class CDiagram;
	class Event;
	class Handler; 
	class Role;
	class UppCanvas;


	//##ModelId=4D63144502FD
	class Canvas : public Visual, public Connectable 
	{
	private:
	
		//##ModelId=4D79B4F801AC
		Handler* player;

  public:
  
    //##ModelId=4D83AC0D009C
  	Handler* get_player();
    //##ModelId=4D83AC0D00CB
  	void set_player(Handler* object);
  
    //##ModelId=4D7F2DD202EE
    typedef Array<Canvas*> CanvasVector;
    
    //##ModelId=4D73C31A009C
    typedef Array<Connector*> ConnectorVector;


		//##ModelId=4D6314460000
		bool selected;

		//##ModelId=4D63144503BC
		Canvas * owner;

		// allows Arrow to be a ref in ConnectorEnd
		//##ModelId=4D6314460001
    Canvas();

		//##ModelId=4D631446000F
		Canvas(Canvas* );
		//##ModelId=4D86291D030D
		Canvas(Canvas*,float,float,float,float);
		
		//##ModelId=4D84C8F7001F
    virtual ~Canvas(){ 
    }
		
		//protocol: serialization
		//##ModelId=4D7EC6D5034B
    virtual void Serialize(Stream& stream);
		
		//##ModelId=4D631446001F
		inline virtual void notify(Event* ) {};
			
		
		//##ModelId=4D6314460030
		UppCanvas* root();
		
		//##ModelId=4D6C7BD00167
		Canvas* view();
		
		//##ModelId=4D6314460031
		virtual bool isConnector();
		//##ModelId=4D6314460033
		virtual bool isShape();
		//##ModelId=4D79238C0228
    virtual bool isText();
		//##ModelId=4D631446002E
		virtual bool isView();
		
		
    //##ModelId=4D85D202030D
		virtual bool isContainer(){return false;}
		
    //##ModelId=4D85D202033C
		virtual Container* asContainer(){
			assert(isContainer());
			return (Container*) this;
		}

		
		//##ModelId=4D6573DA0167
		virtual int get_radius() const;
		
		//##ModelId=4D6573DE035B
		virtual void set_radius(int left);
		//##ModelId=4D6C566600DA
		void setFlag(bool value);
		//##ModelId=4D6C567902DE
		bool getFlag();
		
		
		//##ModelId=4D7F159301B5
		void add(Role* obj);

	  // same as add, but attach the canvas to the mouse
	  //##ModelId=4D74A40C00CB
	  virtual void openInHand(Canvas* c);
    //##ModelId=4D83D194031C
	  virtual void open(Canvas* c);
	  
    //##ModelId=4D82006E0186
	  virtual void openInHand();
    //##ModelId=4D83D26103D8
	  virtual void open();

    //##ModelId=4D72EEA5036B
    virtual bool isDragging();


    //##ModelId=4D73BE0B0399
    CDiagram* diagram();

    //##ModelId=4D743F85001F
    virtual void beMinimal();

    //##ModelId=4D743F8F0290
    virtual void beNormal();
    
    // MTDrag send this to say it has finished sending moveRelative msgs
    //##ModelId=4D7442AD0157
    virtual void stopMoving();
    //##ModelId=4D74C5E1007D
    virtual void remove();

    // protocol: converting
    //##ModelId=4D75767F035B
    Connector* asConnector();
    // protocol: converting
    //##ModelId=4D7581450290
    Canvas* asCanvas();


    


  private:

    // moveRelative use this to avoid multiple dispatches
    //##ModelId=4D6C55E60109
    bool flag;
	};
	
	
	

	//##ModelId=4D623ACE0138
	class TextStyle
	{
	  public:
    //##ModelId=4D623EB301F4
    TextStyle();

    //##ModelId=4D623AD70271
    bool bold;

    //##ModelId=4D623E4B038A
    bool underline;
	};

	//##ModelId=4D605633015C
	class Rectangle : public Canvas {
	  public:
	    //##ModelId=4D6056330353
	    Rectangle(Canvas* , float , float , float , float );
	
	    //##ModelId=4D6056330359
	    void paint();
	    
	    //##ModelId=4D605633035A
	    bool isShape();
	    //##ModelId=4D65721B0186
	    int get_radius() const;
	  
	    //##ModelId=4D65721B01E4
	    void set_radius(int left);
	
	  private:
	    //##ModelId=4D6571D901D4
	    int radius;
	};

	//##ModelId=4D6D49A902AF
	class Image : public Rectangle
	{
		public:
		
    //##ModelId=4D6D4D8B029F
		Upp::Image& image;
		
		
    //##ModelId=4D6D4A2C000F
		Image(Canvas* owner, Point origin, Upp::Image& image);
		
    //##ModelId=4D6D4A9101C5
		void paint();
    //##ModelId=4D6D55F301C5
    Point& get_extent();

	};

	class CDiagram;
	class Event;

	//##ModelId=4D6D0861000F
	class CanvasEventListener
	{
  private:
	  public:

    //##ModelId=4D6D091700BD
    CDiagram *destination;
	  
    //##ModelId=4D6D0E82001F
		void dispatch(cv::Event* evt);
		
    //##ModelId=4D6D11E7030D
		void doPaint(Upp::Painter* p);
		
	};

	class CText;

	//##ModelId=4D605633016A
	class UppCanvas {
  public:
  
		//##ModelId=4D605633037C
		Upp::Painter * _draw;
		
		//##ModelId=4D605633037D
		inline UppCanvas(Upp::Painter * d) :_draw(d){/**/};
		
		//##ModelId=4D605633037F
		void drawCircle(Point center,float radius,int lineWidth,Upp::Color);
		
		//##ModelId=4D6056330384
		void drawLine(Point start, Point end, int width, Upp::Color c = Upp::Black);
		
		//##ModelId=4D6056330389
		void drawLine(float , float , float , float , int width, Upp::Color c = Upp::Black, float angle=0, float x=0, float y=0);

		//##ModelId=4D6056330393
		void drawPoly(Rect r, int lineWidth, Upp::Color borderColor=Upp::Black	, Upp::Color fillColor=Upp::White);
    //##ModelId=4D6312F0035B
		void drawEmptyPoly(Rect& r, int lineWidth, Upp::Color c=Upp::Black);
			
		//##ModelId=4D6056330397
		void drawImage(float x, float y, Upp::Image , float alpha);
    //##ModelId=4D7B3B34034B
		void drawImage(float x, float y, Upp::Image);
		
    //##ModelId=4D65522300BB
		void drawRoundRectangle(Rect r, float radius, int lineWidth=1, Upp::Color borderColor=Upp::Black);
		
    //##ModelId=4D622CC50280
    Point textSize(std::string text);

    //##ModelId=4D6228180213
    void drawText(CText* text);
    
    //##ModelId=4D653F700222
    void setCursor(std::string);

    //##ModelId=4D62440D0251
    void drawEllipse(float x,float y,float cx,float cy,Upp::Color color=Upp::Black, int lineWidth=1);

	};

	//##ModelId=4D6056330109
	class Ellipse : public Rectangle {
  public:
    
    //##ModelId=4D62461700FA
    Ellipse(Canvas* owner, float x, float y, float cx, float cy);
    
    //##ModelId=4D6246B0033C
    void paint();

    //##ModelId=4D6248AC0222
    Point const& get_extent();
    //##ModelId=4D624B480242
    void moveRelative(Point pt);
	};

	//##ModelId=4D6221CF00BB
	class CText : public Rectangle 
	{
	public:

		//##ModelId=4D6C68FB007D
		CText(Canvas* _owner);
		
		//##ModelId=4D6225CF005D
		CText(Canvas* _owner, float x, float y);
		
		//##ModelId=4D6221CF012A
		String get_contents() const;
		
		//##ModelId=4D6221CF012C
		void set_contents(String left);
		
		//##ModelId=4D6221CF012E
		void paint();
		
		//##ModelId=4D622AFE0119
		Point const& get_extent();

		//##ModelId=4D791FE40053
		void edit();
		
		//##ModelId=4D7923E9017C
		bool isText(){return true;}

		//##ModelId=4D623AF303A9
		TextStyle style;

	private:
		
		//##ModelId=4D6221CF0129
		String contents;
	};

	//##ModelId=4D6C6A1A033C
	class Separator : public Canvas
	{
		public:
	
    //##ModelId=4D6C6B0D0177
		Separator(Canvas* owner)
			:Canvas(owner)
			,horizontal(true)
			{}
	  
    //##ModelId=4D6C6A75031C
    bool horizontal;
    
    //##ModelId=4D6C6C860280
    void paint();
    
    //##ModelId=4D6C712D02EE
    const Point& get_extent();
    
    //##ModelId=4D6C6EEC0000
    bool isElastic();

	
	};

	// TODO Does a group is a View too?
	//##ModelId=4D6AA1900290
	class Group : public Canvas, public Container
	{
    //##ModelId=4D85CAD3032D
		Rect _bounds;
	  public:
	
		//##ModelId=4D6C72360222
		bool bordered;
		
		//##ModelId=4D6AA3B80148
		Rect& bounds();
		
		//##ModelId=4D6AA64401B5
		Group(Canvas* owner);
		
    //##ModelId=4D85E0FD0251
		virtual ~Group();

	    //##ModelId=4D6AA68400AB
	    void paint();
	    
	    //##ModelId=4D85DAD000BB
	    void remove();
	    
	    
	    // MTPick need this
	    //##ModelId=4D6AADE3008C
	    bool isShape();
	    
    //##ModelId=4D6D4CB203B9
	    Image* addImage(Upp::Image& image);
	    //##ModelId=4D6C711D01A5
	    void addSeparator();
	    //##ModelId=4D6C7677032C
	    CText* addText(std::string text);
	    //##ModelId=4D6D43760000
	    Ellipse* addEllipse();

    //##ModelId=4D85D23A005D
    bool isContainer() {return true;}
    //##ModelId=4D85F085005D
    void remove(Canvas* part);


	
	  private:
	    //##ModelId=4D6AA5FE01F4
	    int spacing;
	};

	//##ModelId=4D605633015D
	class Selection {

	  private:
    //##ModelId=4D85CAD30399
    Array<Canvas*> elts;
	
	  public:
		//##ModelId=4D605633035C
		Rect bounds();
		
		//##ModelId=4D6D591A0203
		void selectOnly(Canvas* obj, bool persistent=false);
		
		//##ModelId=4D605633035D
		void add(Canvas* );
		
    //##ModelId=4D745D3801D4
		Canvas* at(int index);
		
		//##ModelId=4D73CE4200BB
		void toggle(Canvas* c);
		
		//##ModelId=4D605633035F
		void clear();
		
		//##ModelId=4D6056330360
		bool includes(Canvas* );
		
    //##ModelId=4D7F07A60232
		bool isEmpty(){ return elts.IsEmpty(); }
		
		//##ModelId=4D6056330362
		void moveRelative(Point );
		
		//##ModelId=4D6056330364
		void remove(Canvas* );
		
		//##ModelId=4D6056330366
		int size();
		// MTDrag send this to say it has finished sending moveRelative msgs
		//##ModelId=4D7441490271
		void stopMoving();
		
		// Selections of one canvas set on the flight by the free hand
		// are not persistent. Only when you click a canvas the selection
		// results to be persistent.
		//##ModelId=4D6D1EB5035B
		bool persistent;
	};

	class Command;
	class Connector;
	class EditorDialog;
	class Handler;
	class MTPick;
	class MTDrag;
	class MTConnect;
	class HighLight;
	class MTracker;
	class MTPickRelative;
	class Tool;
	
	// I'm responsible of displaying a set of canvas into a CanvasCtrl
	// 
	// -- moveRelative
	// to avoid query/stating the list of incoming/outcoming
	// connections --> try to dispatch MOVERELATIVE to involved
	// connectors from the top (i.e.: those connectors are not selected,
	// but get dispatched too)
	//##ModelId=4D60563300EB
	class CDiagram : public Canvas, public UppCanvas, public Container 
	{
		public:

    //##ModelId=4D6EDB6C02BF
		typedef CDiagram CLASSNAME;
    //##ModelId=4D7942180267
    typedef Array<Tool*> ToolsVector;

    //##ModelId=4D714D5E007D
    Connector* nearestConnector(Point p);
		
		//##ModelId=4D6056330237
		CDiagram();
    //##ModelId=4D84BEC703A9
		~CDiagram();
		
    //##ModelId=4D6CC7C0031C
    void show();
	    
		//##ModelId=4D81BE930001
		CDiagram::ToolsVector tools;
		
		
		//##ModelId=4D6056330229
		Selection selection;
		
		//##ModelId=4D77886C036B
		MTPick * picker;
		//##ModelId=4D77890E0186
		MTPickRelative * relativePicker;
		//##ModelId=4D7789E10399
		MTConnect *connector;
		//##ModelId=4D7788EE00DA
		MTDrag *dragger;
    //##ModelId=4D7789310186
		HighLight *highLighter;
    //##ModelId=4D77894602FD
		MTracker * tracker;
		
		//##ModelId=4D6D09B803BA
		CanvasEventListener listener;
		
		// whether a draggin or handling operation is occurring
    //##ModelId=4D72F02A031C
		bool isDragging();

		//##ModelId=4D653E760119
		void setCursor(std::string name);
		
		//##ModelId=4D631B610157
		void moveInFront(Canvas* c);
		
		//##ModelId=4D6056330239
		void notify(Event* );
		
		//##ModelId=4D605633023B
		void paint();
		
		// bounds get evaluated during paint()
		//##ModelId=4D71253300AB
		Rect& bounds(){ return _bounds; }
		
		//##ModelId=4D605633023C
		void add(Tool* );
		
		//##ModelId=4D605633023E
		void add(Canvas* );
		
		//##ModelId=4D6056330240
		inline bool isView() {return true;}
		
		// protocol: model-view
		//##ModelId=4D63F536001F
		void startWiring(Connector* cn);
		//##ModelId=4D713A89030D
		void remove(Canvas* c);
		
		//##ModelId=4D7151BC02FD
		void selectConnectorRelativePoint();
		
		// BUGGED
		//##ModelId=4D73BEE4002E
		void selectTree(Canvas* c);
		
    // same as add, but attach the canvas to the mouse
    //##ModelId=4D74A53301A5
    virtual void openInHand(Canvas* c);
    //##ModelId=4D83D261033C
    virtual void open(Canvas* c);
    //##ModelId=4D74AF9E0119
    void selectAll();
    //##ModelId=4D74B9B80196
    bool isWiring();

    //##ModelId=4D74C0BA02EE
    void clear();
    //##ModelId=4D74D8790138
    bool isPicking();
    //##ModelId=4D7578BB035B
    Canvas* lookupSole(Handler* m);
    //##ModelId=4D85D23603A9
    bool isContainer() {return true;}
    //##ModelId=4D85DD59009C
    void remove();



	private:
	
		//##ModelId=4D62226901F4
		void initialize();
		//##ModelId=4D71229F0186
		Rect _bounds;
	};

	//##ModelId=4D605633016C
	enum eventTag {
	  LEFT_DOWN,
	  LEFT_DRAG,
	  LEFT_UP,
	  MOUSE_MOVE,
	  KEY_DEL,
	  KEY_INS
	
	};

	//##ModelId=4D605633016E
	enum keyModifiers {
	  K_SHIFT =  2
			,
	  K_CONTROL =  4
			,
	  K_ALT =  8
		
	
	};


	/* event class
	is a class
	*/
	//##ModelId=4D605633010A
	class Event
	{
  public:
    //##ModelId=4D60563302A5
    Event(eventTag _tag, Point _p)
    	: tag(_tag)
    	, pt(_p)
    {/**/};

    //##ModelId=4D60563302A8
    Event(eventTag _tag, double x, double y)
    	: tag(_tag)
    	, pt(Point(x,y))
    {/**/};

    //##ModelId=4D60563302AC
    bool isMouseEvent(){return true;}
    
    // - a push-button activation
    //##ModelId=4D6D15360186
    bool isCommandEvent(){return false;}
    
    //##ModelId=4D60563302AD
    bool isKeyboardEvent(){return false;}

  	//##ModelId=4D60563302A4
    int key_modifiers;

    //##ModelId=4D605633029B
    Point pt;

    //##ModelId=4D6056330296
    eventTag tag;

    //##ModelId=4D7F2DD300FB
    Canvas::CanvasVector subjects;
	};




} // namespace cv

#endif


