#ifndef CV_CONNECTOR_H
#define CV_CONNECTOR_H

#include <vector>
#include "canvas.h"
#include "connector.h"
#include "canvas/connector.h"
#include "canvas/canvas.h"

namespace cv {

	class Arrow;
	class Attachment;
	class ConnectorEnd;
	class ConnectorSegment;
	class Label;

	//##ModelId=4D60563300EC
	class Connector : public Canvas 
	{
	public:
		
		//##ModelId=4D7303770271
		enum ConnectPolicy {Oblique, Orthogonal};
		
		
		//##ModelId=4D7D73BD009C
		typedef Array<ConnectorSegment*> Segments;

  public:
    //##ModelId=4D6056330243
  public:
    //##ModelId=4D6056330243
		ConnectorEnd * head;
		
		//##ModelId=4D6056330248
		ConnectorEnd * tail;
		
    //##ModelId=4D830F5C032C
		bool isWiring;
		
		//##ModelId=4D605633025B
		Connector(Canvas* owner);
		//##ModelId=4D605633025D
		Connector(Canvas* owner, Canvas* tail);
		//##ModelId=4D6056330260
		Connector(Canvas* owner, Canvas* head, Canvas* tail);
		
		//##ModelId=4D66CDC4037A
		// affects bounds()
		Point& get_origin();
		//##ModelId=4D66CDC4038A
		// affects bounds()
		Point& get_extent();

    //##ModelId=4D72D24000DA
    Rect& bounds();
		
    
    //##ModelId=4D72C1600196
    ConnectorSegment* addPoint(Point p);
    
    // used when wiring 
    //##ModelId=4D83104203A9
    void appendSegmentAt(Point p);

    // private
    //##ModelId=4D8310AC0271
    ConnectorSegment* insertSegmentBefore(int index, Point p);
    //##ModelId=4D831360007D
    ConnectorSegment* insertSegmentAfter(int index, Point p);

		//##ModelId=4D6056330264
		void paint();
		
		
		// answer the relative quote from TAIL
		// of the connector's point nearest to P
		//##ModelId=4D6462CB0128
		double relative(Point& p);
		
    //##ModelId=4D7159C5007D
		Vect relative(Position pos);

    //##ModelId=4D6457000167
		// - QUOTE =  [0..1]
		// - answer a point that is QUOTE/percent 
		// of the connector length starting from the TAIL
		// 
    Vect relative(double quote);
		
    //##ModelId=4D7E16E80399
		void relative(Attachment* att);
				
		//##ModelId=4D691F2400AB
		void moveRelative(Point p);
		
		//##ModelId=4D609571032C
		Point center();
		
		// - connector's length
    // - evaluates (1) waypoints lengths (1) alphas
    //##ModelId=4D645A94000F
		double length();
		
		// protocol: connecting
    //##ModelId=4D6056330265
		void connect(Canvas* c);
		
		//##ModelId=4D72BAC3007D
		void connect(Canvas* tailSide, Canvas* headSide);

    //##ModelId=4D72C07F01F4
		bool contains(Point pt);
		
		//##ModelId=4D6056330269
		bool isConnector();
		//##ModelId=4D613EBB0251
		bool isConnectedTo(Canvas* c);
		
		//##ModelId=4D64434B00CB
		void showArrows(bool state=true);
		
		//##ModelId=4D85CAD302DE
		Array<Label*> labels;
		
		//##ModelId=4D6EE69B02FD
		bool dashed;
    //##ModelId=4D7D73DE01D4
    Segments segments;


		//##ModelId=4D6328840196
		Label* addLabel(std::string text, Position position);
    //##ModelId=4D72F40C0109
    void compactSegments();
    //##ModelId=4D74400E02AF
    virtual void beMinimal();


    //##ModelId=4D744011008C
    virtual void beNormal();
    // MTDrag send this to say it has finished sending moveRelative msgs
    //##ModelId=4D74432D0399
    virtual void stopMoving();

    //##ModelId=4D74C74D030D
    void remove();
    // protocol: converting
    //##ModelId=4D75815E029F
    Canvas* asCanvas();

    // do not move (since its ends should move when ends canvas move)
    //##ModelId=4D7772AF003E
    void move(float x, float y);
    // do not move (since its ends should move when ends canvas move)
    //##ModelId=4D7773870213
    void move(Point p);

    //##ModelId=4D7AB89F03C8
    // set the wayPoint as the current active-point
    void setActiveSegment(int index);
    // look-for a waypoint near to PT, is found set it as the activepoint
    //##ModelId=4D7AB96702EE
    void setActiveSegment(Point pt);
    //##ModelId=4D7D9548030D
    ConnectorSegment& firstSegment();


    //##ModelId=4D7D956303B9
    ConnectorSegment& lastSegment();
    //##ModelId=4D7DA44002AF
    virtual void set_extent(Point left);


    //##ModelId=4D7DA4460000
    virtual void set_origin(Point left);
    // remove alla segments. Retargeting head/tail call this.
    //##ModelId=4D7E1E84003E
    void removeSegments();


  private:
    //##ModelId=4D72EC6A032C
    ConnectorSegment* activeSegment;

	};

	//##ModelId=4D60563300CB
	enum ArrowType {
	  None, ClosedEmpty,
	  ClosedFilled,
	  OpenArrow,
	  DiamondEmpty,
	  DiamondFilled
	};
	
	//##ModelId=4D60563300BB
	class Arrow : public Canvas {
		public:
		//##ModelId=4D60563301B4
		ArrowType type;
		
		//##ModelId=4D60563301B8
		Arrow(ArrowType t = OpenArrow);
		
		//##ModelId=4D60563301BB
		void paint(float rotation);
		
		//##ModelId=4D60563301BD
		void paint();
	};


	//##ModelId=4D7D725E001F
	class ConnectorSegment : public Line
	{
  public:
    //##ModelId=4D7EAEAA007D
    enum constraints { free, xortho, yortho };

    //##ModelId=4D7EAEF8007D
    constraints kind;

    //##ModelId=4D7DA8E003C8
    void moveRelative(Point p);

    //##ModelId=4D7DAEE802EE
    ConnectorSegment(Connector* owner);

    //##ModelId=4D7D761802AF
    double _length;
	
    //##ModelId=4D7D761A02AF
    double _alpha;
    //##ModelId=4D7DA8BC00BB
    ConnectorSegment* nextSegment;
    //##ModelId=4D7DAEBA036B
    ConnectorSegment* prevSegment;
    //##ModelId=4D7DAF230242
    bool movingPoint;
    //##ModelId=4D7E24F6003E
    Connector *connector;
    //##ModelId=4D7EAD7D0109
    bool ortho;

	};

	//##ModelId=4D60563300CE
	enum AttachmentPolicy {att_vector, att_relative, att_center, att_absolute, att_positional, att_free};

	//##ModelId=4D60563300CD
	class Attachment
	{
	  public:
		//##ModelId=4D60563301D3
		Attachment();

		/* Attachment::quote
		@when( policy == att_relative )
		-> a 0..1 percent of distance from reference point
		
		@when( policy == att_absolute )
		-> number of pixels from reference point */
		//##ModelId=4D60563301C3
		double quote;

		//##ModelId=4D60563301C5
		AttachmentPolicy policy;

		//##ModelId=4D60563301CA
		Position position;

		// when (policy == att_free)
    // indicates the Point where the ConnectorEnd points to

    //##ModelId=4D60563301CF
		Point freePoint;
    //##ModelId=4D67025D002E
    Vect vector;
    //##ModelId=4D7DDE100196
    ConnectorSegment* segment;
	};

	//##ModelId=4D60563300FA
	class ConnectorEnd 
	{
    // todo check why this friendship
    friend class Connector;
    // TODO remove this friend
    // selected label must show a line to the attachment point
    // when isVector the connector-relative is hidden
    friend class Label;

		private:
	  
    //##ModelId=4D6056330284
    ConnectorEnd* counterPart();
    
    //##ModelId=4D6056330270
    Attachment attachment;
    // the Canvas this ConnectorEnd connects to
    //##ModelId=4D631446006E
    Canvas * canvas;

	  public:
    //##ModelId=4D6056330285
    ConnectorEnd(Connector* connector, Canvas* c);
    //##ModelId=4D6056330288
    ConnectorEnd(Connector* connector);
    
    //##ModelId=4D6056330275
    Connector * connector;


    //##ModelId=4D73C92E0000
		bool isTail();
    //##ModelId=4D73C92E002E
		bool isHead();

    //##ModelId=4D605633028A
    Point point(bool cached=true);

    //##ModelId=4D86291E00BC
    Arrow arrow;

    
    // only for labels
    // (since Connectors are using segment start/end)
    //##ModelId=4D7D984800BB
    Point vectorPoint;

    // protocol: connecting
    //##ModelId=4D605633028B
    bool connected();

    //##ModelId=4D6056330290
    void beFree();
    // protocol: connecting
    //##ModelId=4D605633028C
    void beFree(Point& pt);
    //##ModelId=4D6056330291
    bool isFree();
    // protocol: connecting
    //##ModelId=4D605633028E
    void beCentered(Canvas* c);

    // protocol: connecting
    // set relative to a point
    // todo? Canvas MUST be a Connector
    //##ModelId=4D646A6B0128
    void beRelative(Canvas* c, Point& p);
    
    // protocol: connecting
    // set relative to a position (head/center/tail)
    // todo? Canvas MUST be a Connector
    //##ModelId=4D690D730196
		void beRelative(Canvas* c, Position pos);
    
    //##ModelId=4D670871001F
    bool isVector(){ return attachment.policy==att_vector; }
    // protocol: connecting
    //##ModelId=4D6705CD006D
    void beVector(Vect v);
    //##ModelId=4D679850009C
    void moveRelative(Point delta);
    

    // protocol: connecting
    //##ModelId=4D7D438F009C
    void registerConnector();
    //##ModelId=4D84B25801D4
    Canvas* get_canvas();


    //##ModelId=4D84B28B0261
    void set_canvas(Canvas* object);



	  protected:
	};

	// I'm always attached asVector
	//##ModelId=4D63222502CE
	class Label : public CText
	{
		//bool moving_relative;
		public:
		
		// add some space around, so that
		// connectors do not hurt its letters.
		//##ModelId=4D83E437007D
    Rect& bounds();
		
    //##ModelId=4D6711530000
		void moveRelative(Point p);
		
		//##ModelId=4D632A3203B9
		Label(Connector* owner, std::string text);
		
		// A Point over a Connector where Label isRelative is attached.
    // For isVector labels it represents the Point where their vectors
    // are attached
    //##ModelId=4D691F240167
    Point attachment();
		
		//##ModelId=4D632D41038A
		void paint();
    //##ModelId=4D7D643801C5
    Point& get_origin();
    //##ModelId=4D7D65B20213
    void set_origin(Point p);


		//##ModelId=4D66E4410178
		ConnectorEnd* end;
		
	};


} // namespace cv
#endif
