/*
 * ImageMgr.cpp
 *
 *  Created on: 18 juin 2010
 *      Author: didier
 */

#include "ImageMgr.h"

#include "plugin/jpg/jpg.h"

// @ renvoi l'image ayant l'identifiant imgId dans la base
Image  ImageMgr::getImage(int imgId)
{
	LOG( String("ImageMgr::getImage( ") << imgId << " )" );
	if (imgId != -1)
	{
		Sql sql;
		sql * Select(IMG_DATA).From(IMAGES).Where(IMG_ID == imgId);
		return 	JPGRaster().LoadStringAny( sql[IMG_DATA] );
	}
	else return Image();
}

// @ renvoi l'image ayant l'identifiant imgId dans la base
String  ImageMgr::getImageString(int imgId)
{
	LOG( String("ImageMgr::getImageString( ") << imgId << " )" );
	if (imgId != -1)
	{
		Sql sql;
		sql * Select(IMG_DATA).From(IMAGES).Where(IMG_ID == imgId);
		return sql[IMG_DATA];
	}
	else return String("");
}

// @ renvoi le sql Id de l'image insere dans la base
int ImageMgr::addImage(const Image& img)
{
	LOG( "ImageMgr::addImage()");
	int resId=0;
	Sql sql;
	S_IMAGES imgStruct;
	imgStruct.IMG_HASH = img.GetHashValue();
	sql * Insert(IMAGES)(imgStruct);
	resId = sql.GetInsertedId();

	sql * SqlUpdate(IMAGES)(IMG_DATA, SqlBinary( JPGEncoder().SaveString(img) ) ).Where(IMG_ID == resId);
	sql.Commit();
	return resId;
}

int ImageMgr::addImageString(const String& imgStr )
{
	LOG( "ImageMgr::addImage()");
	Image img = JPGRaster().LoadStringAny( imgStr );
	int resId=0;
	Sql sql;
	S_IMAGES imgStruct;
	imgStruct.IMG_HASH = img.GetHashValue();
	sql * Insert(IMAGES)(imgStruct);
	resId = sql.GetInsertedId();
	sql * SqlUpdate(IMAGES)(IMG_DATA, SqlBinary( JPGEncoder().SaveString(img) ) ).Where(IMG_ID == resId);
	sql.Commit();
	return resId;
}

// @ renvoi le sql Id de l'image insere dans la base
void ImageMgr::updateImage(int imgId, const Image& img)
{
	LOG( "ImageMgr::updateImage()");
	int resId=0;
	Sql sql;
	S_IMAGES imgStruct;
	dword hash = img.GetHashValue();
	sql * Update(IMAGES)(IMG_DATA, SqlBinary( JPGEncoder().SaveString(img) ) )
//			               (IMG_HASH, hash)  //TODO  a corriger
			.Where(IMG_ID == imgId);
	sql.Commit();
}


void ImageMgr::deleteImage(int imgId)
{
	
}
