#include <CtrlLib/CtrlLib.h>
#include <Draw/Draw.h>
#include <EditImage/EditImage.h>
#define IMAGECLASS EditImageIml
#define IMAGEFILE <EditImage/EditImage.iml>
#include <Draw/iml.h>
#include <Web/Web.h>

struct FilePreviewDisplay : Display
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const {
		Size sz = Size(w.GetPaintRect().Width(),w.GetPaintRect().Height());
		w.DrawRect(0, 0, sz.cx, sz.cy, SColorFace);
		if (FileExists((String)q)) {
			String ext = ToUpper(GetFileExt((String)q));
			Image img;
			if (ext==".PNG" ||ext==".JPG"||ext==".GIF"||ext==".TIF"||ext==".BMP") {
				img = PropRescale(StreamRaster::LoadFileAny((String)q),sz);
			} else {
				img = EditImageIml::NoImage();
			}
			Size ssz = img.GetSize();
			w.DrawImage((sz.cx-ssz.cx)/2, (sz.cy-ssz.cy)/2, img, w.GetPaintRect());
		}
	}
};



EditImage::EditImage() {
	InsertFrame(1, imagebar.Bottom());
	InsertFrame(2, BottomSeparatorFrame());
	WhenAction = THISBACK(ViewImage);
	
	imagebar.Add(t_("Insert Image"), EditImageIml::Append(), THISBACK(SaveImage));
	imagebar.Add(t_("View Image"), EditImageIml::Find(), THISBACK(ViewImage));
	imagebar.Add(t_("Paste Image"), EditImageIml::Paste(), THISBACK(PasteImage));
	imagebar.Add(t_("Save Image"), EditImageIml::Save(), THISBACK(SaveToFileImage));
	//imagebar.ToolGap(3);
	imagebar.Add(t_("Erase Image"), EditImageIml::Delete(), THISBACK(EraseImage));
	bg = Null;
	storeddimension = Size(300,300);
	

}

void EditImage::SaveImage() {
	static String savedfolder;
	FileSel fs;
	fs.Multi(false);
	fs.Preview(Single<FilePreviewDisplay>());
	fs.splitter.SetPos(1000,0);
	fs.splitter.SetPos(8000,1);
	
	PNGEncoder png;
	if (!savedfolder.IsEmpty()) 
		fs.ActiveDir(savedfolder);
	fs.Type(t_("All Graphic files"), "*.jpg *.png *.gif *.tif *.bmp *.pcx");
	fs.Type(t_("PNG files"), "*.png");
	fs.Type(t_("JPG files"), "*.jpg");
	fs.Type(t_("GIF files"), "*.gif");
	fs.Type(t_("TIF files"), "*.tif");
	fs.Type(t_("BMP files"), "*.bmp");
	
	if(!fs.ExecuteOpen()) 
		return;
	savedfolder = fs.GetActiveDir();
	image = StreamRaster::LoadFileAny(~fs);
	
	image = PropRescale(image,storeddimension);
	SetImage(image);
}

void EditImage::Paint(Draw& draw) { 
		if (!bg.IsNullInstance())
			draw.DrawRect(GetSize(), bg);
		if (HasMouse() && !norepaint) 
			draw.DrawRect(GetSize(), SColorHighlight());

		Size sz = GetSize();
		if (!image.IsEmpty()) {
			Image img = PropRescale(image,sz);
			Size ssz = img.GetSize();
			draw.DrawImage((sz.cx-ssz.cx)/2, (sz.cy-ssz.cy)/2, img, (Rect)GetSize());
		} else {
			Size ssz = EditImageIml::NoImage().GetSize();
			draw.DrawImage((sz.cx-ssz.cx)/2, (sz.cy-ssz.cy)/2, EditImageIml::NoImage(), (Rect)GetSize());
		}

}		

void EditImage::ViewImage() {
	if(image.IsEmpty()) return;
	ViewImageDlg viewdlg;
	if (!defaultviewsz.IsEmpty()) viewdlg.SetWindowSize(defaultviewsz);
	viewdlg.SetImage(image);
	viewdlg.Execute();
}

void EditImage::EraseImage() {
	if(PromptYesNo(t_("Are you sure to delete image from table?"))) {
		image.Clear();
		SetImage(EditImageIml::NoImage());
	}
}

void EditImage::PasteImage() {
	image = ReadClipboardImage();
	if (image.IsEmpty()){
		image.Clear();
		SetImage(EditImageIml::NoImage());
		return;
	}
	image = PropRescale(image,300,300);
	SetImage(image);
}

void EditImage::DragAndDrop(Point p, PasteClip& d) {
	
	if(AcceptImage(d)) {
		
		image = GetImage(d);
		if (image.IsEmpty()){
			image.Clear();
			SetImage(EditImageIml::NoImage());
			return;
		}
		image = PropRescale(image,300,300);
		SetImage(image);
		
	}
	if(AcceptFiles(d)) {
		Vector<String> ff = GetFiles(d);
		if(FileExists(ff[0])) { 
			Image imf = StreamRaster::LoadFileAny(ff[0]);
			image = PropRescale(imf,Size(300,300));
			ff.Clear();
			SetImage(image);
		} else if (FileExists(UrlDecode(ff[0]))) { 
			Image imf = StreamRaster::LoadFileAny(UrlDecode(ff[0]));
			image = PropRescale(imf,Size(300,300));
			ff.Clear();
			SetImage(image);
		}

	}
}

void EditImage::SaveToFileImage() {
	if (image.IsEmpty())	return;

	PNGEncoder png;
	FileSel fs;
	fs.MkDirOption();
	fs.DefaultExt("png");
	if(!fs.ExecuteSaveAs(t_("Enter File Name to save PNG Image"))) 
		return;
	png.SaveFile(~fs, image);
}

String EditImage::ToString(){
	PNGEncoder png;
	String retval;
	if (!image.IsEmpty())
		return png.SaveString(image);
	else
		return "";
}

void EditImage::FromString(String s){
	PNGRaster pngr;
	image = pngr.LoadString(s);
}


