#include <EditImage/EditImage.h>
Image PropRescale(const Image& im, const Size res_size){
	Size imsize,ressize=res_size;
	imsize = im.GetSize();
	if (imsize.cx > 0 && imsize.cy > 0) {
		double ixy = double(imsize.cx)/imsize.cy;
		double rxy = double(ressize.cx)/ressize.cy;
		if (rxy>ixy) {
			ressize.cx = ressize.cy*imsize.cx/imsize.cy;
		} else {
			ressize.cy = ressize.cx*imsize.cy/imsize.cx;
		}
		return Rescale(im,ressize);
	}
}

Image PropRescale(const Image& im,const int cx,const int cy) {
	Size ressize;
	ressize.cx = cx;
	ressize.cy = cy;
	return PropRescale(im,ressize);
}

Image PropRescale(const Image& im, const ImageCtrl& imc) {
	Image i = PropRescale(im,imc.GetSize());
	return i;
}

void PropRescale(const Image& im, ImageCtrl& imc ,const bool setimage) {
	Image i = PropRescale(im,imc.GetSize());
	if (setimage) imc.SetImage(i);
	return;
}
